/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.fcqueue;

import com.swirlds.common.crypto.CryptoFactory;
import com.swirlds.common.crypto.Cryptography;
import com.swirlds.common.crypto.DigestType;
import com.swirlds.common.crypto.Hash;
import com.swirlds.common.crypto.ImmutableHash;
import com.swirlds.common.io.SelfSerializable;
import com.swirlds.common.io.SerializableDataInputStream;
import com.swirlds.common.io.SerializableDataOutputStream;
import com.swirlds.common.merkle.utility.AbstractMerkleLeaf;
import com.swirlds.fcqueue.FCQueueElement;
import com.swirlds.fcqueue.FCQueueIterator;
import com.swirlds.fcqueue.FCQueueStatistics;
import com.swirlds.fcqueue.internal.FCQHashAlgorithm;
import com.swirlds.fcqueue.internal.FCQueueNode;
import com.swirlds.fcqueue.internal.FCQueueNodeBackwardIterator;
import com.swirlds.fcqueue.internal.FCQueueNodeIterator;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.time.StopWatch;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FCQueue<E extends FCQueueElement>
extends AbstractMerkleLeaf
implements Queue<E> {
    public static final long CLASS_ID = 139236190103L;
    public static final int MAX_ELEMENTS = 100000000;
    protected static final FCQHashAlgorithm HASH_ALGORITHM = FCQHashAlgorithm.ROLLING_HASH;
    private static final DigestType digestType = DigestType.SHA_384;
    public static final byte[] NULL_HASH = new byte[digestType.digestLength()];
    private static final boolean THROW_ON_HASH_MISMATCH = false;
    private static final Logger log = LogManager.getLogger(FCQueue.class);
    private static final boolean USE_MARKERS = false;
    private static final int BEGIN_QUEUE_MARKER = 175624369;
    private static final int END_QUEUE_MARKER = 175654143;
    protected static final long INVERSE_3 = -6148914691236517205L;
    private int runningHashSize;
    protected int size;
    protected FCQueueNode<E> head;
    protected FCQueueNode<E> tail;
    protected final byte[] hash = new byte[digestType.digestLength()];
    protected int numChanges;

    public FCQueue() {
        this.size = 0;
        this.head = null;
        this.tail = null;
        this.setImmutable(false);
    }

    protected FCQueue(FCQueue<E> fcQueue) {
        super(fcQueue);
        this.size = fcQueue.size;
        System.arraycopy(fcQueue.hash, 0, this.hash, 0, this.hash.length);
        this.head = fcQueue.head;
        this.tail = fcQueue.tail;
        this.runningHashSize = fcQueue.runningHashSize;
        this.setImmutable(false);
    }

    public int getNumChanges() {
        return this.numChanges;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hash getHash() {
        int currentRunningHashSize;
        byte[] localHash;
        Iterator<FCQueueNode<E>> it;
        int currentSize;
        StopWatch watch = new StopWatch();
        watch.start();
        FCQueue fCQueue = this;
        synchronized (fCQueue) {
            if (this.head == null) {
                return new ImmutableHash(FCQueue.getNullHash());
            }
            if (this.size == this.runningHashSize) {
                return new ImmutableHash(this.hash);
            }
            currentSize = this.size;
            it = this.nodeBackwardIterator();
            localHash = Arrays.copyOf(this.hash, this.hash.length);
            currentRunningHashSize = this.runningHashSize;
        }
        int limit = currentSize - currentRunningHashSize;
        FCQHashAlgorithm.increaseRollingBase(limit, localHash);
        for (int index = 0; index < limit; ++index) {
            byte[] elementHash;
            FCQueueNode<E> node = it.next();
            if (node.getElementHashOfHash() == null) {
                elementHash = this.getHash((FCQueueElement)node.getElement());
                node.setElementHashOfHash(elementHash);
            } else {
                elementHash = node.getElementHashOfHash();
            }
            HASH_ALGORITHM.computeHash(localHash, elementHash, index);
        }
        FCQueue fCQueue2 = this;
        synchronized (fCQueue2) {
            this.runningHashSize = currentSize;
            System.arraycopy(localHash, 0, this.hash, 0, this.hash.length);
        }
        watch.stop();
        FCQueueStatistics.fcqHashExecutionMicros.recordValue((double)watch.getTime(TimeUnit.MICROSECONDS));
        return new ImmutableHash(this.hash);
    }

    public void setHash(Hash hash) {
        throw new UnsupportedOperationException("FCQueue computes its own hash");
    }

    public boolean isSelfHashing() {
        return true;
    }

    @Override
    public synchronized boolean add(E o) {
        FCQueueNode node;
        StopWatch watch = null;
        if (FCQueueStatistics.isRegistered()) {
            watch = new StopWatch();
            watch.start();
        }
        if (this.isImmutable()) {
            throw new IllegalStateException("tried to modify an immutable FCQueue");
        }
        if (o == null) {
            throw new NullPointerException("tried to add a null element into an FCQueue");
        }
        if (this.size() >= 100000000) {
            throw new IllegalStateException(String.format("tried to add an element to an FCQueue whose size has reached MAX_ELEMENTS: %d", 100000000));
        }
        if (this.tail == null) {
            node = new FCQueueNode(o);
            this.head = node;
        } else {
            node = this.tail.insertAtTail(o);
            node.setTowardHead(this.tail);
            node.setTowardTail(null);
            this.tail.setTowardTail(node);
            this.tail.decRefCount();
        }
        this.tail = node;
        ++this.size;
        ++this.numChanges;
        if (watch != null) {
            watch.stop();
            FCQueueStatistics.fcqAddExecutionMicros.recordValue((double)watch.getTime(TimeUnit.MICROSECONDS));
        }
        return true;
    }

    @Override
    public synchronized E remove() {
        StopWatch watch = null;
        if (FCQueueStatistics.isRegistered()) {
            watch = new StopWatch();
            watch.start();
        }
        FCQueueNode<E> oldHead = this.head;
        if (this.isImmutable()) {
            throw new IllegalArgumentException("tried to remove from an immutable FCQueue");
        }
        if (this.size == 0 || this.head == null) {
            throw new NoSuchElementException("tried to remove from an empty FCQueue");
        }
        byte[] elementHash = this.head.getElementHashOfHash();
        FCQueueElement element = (FCQueueElement)this.head.getElement();
        this.head = this.head.getTowardTail();
        if (this.head == null) {
            this.tail.decRefCount();
            this.tail = null;
        } else {
            this.head.incRefCount();
        }
        oldHead.decRefCount();
        --this.size;
        ++this.numChanges;
        if (elementHash != null && this.runningHashSize > 0) {
            --this.runningHashSize;
            HASH_ALGORITHM.computeRemoveHash(this.hash, elementHash, this.runningHashSize);
        }
        if (watch != null) {
            watch.stop();
            FCQueueStatistics.fcqRemoveExecutionMicros.recordValue((double)watch.getTime(TimeUnit.MICROSECONDS));
        }
        return (E)element;
    }

    @Override
    public synchronized boolean offer(E o) {
        return this.add(o);
    }

    @Override
    public synchronized E poll() {
        if (this.head == null) {
            return null;
        }
        return (E)this.remove();
    }

    @Override
    public synchronized E element() {
        if (this.head == null) {
            throw new NoSuchElementException("tried to get the head of an empty FCQueue");
        }
        return (E)((FCQueueElement)this.head.getElement());
    }

    @Override
    public synchronized E peek() {
        if (this.head == null) {
            return null;
        }
        return (E)((FCQueueElement)this.head.getElement());
    }

    public synchronized FCQueue<E> copy() {
        if (this.isImmutable()) {
            throw new IllegalStateException("Tried to make a copy of an immutable FCQueue");
        }
        FCQueue<E> queue = new FCQueue<E>(this);
        this.setImmutable(true);
        if (this.head != null) {
            this.head.incRefCount();
        }
        if (this.tail != null) {
            this.tail.incRefCount();
        }
        return queue;
    }

    protected synchronized void onRelease() {
        this.clearInternal();
        super.onRelease();
    }

    @Override
    public synchronized int size() {
        return this.size;
    }

    @Override
    public synchronized boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public synchronized boolean contains(Object o) {
        for (FCQueueElement e : this) {
            if (!Objects.equals(o, e)) continue;
            return true;
        }
        return false;
    }

    @Override
    public synchronized Iterator<E> iterator() {
        return new FCQueueIterator<E>(this, this.head, this.tail);
    }

    public Iterator<E> reverseIterator() {
        return new Iterator<E>(){
            private final Iterator<FCQueueNode<E>> nodeIterator;
            {
                this.nodeIterator = FCQueue.this.nodeBackwardIterator();
            }

            @Override
            public boolean hasNext() {
                return this.nodeIterator.hasNext();
            }

            @Override
            public E next() {
                return (FCQueueElement)this.nodeIterator.next().getElement();
            }
        };
    }

    protected synchronized Iterator<FCQueueNode<E>> nodeIterator() {
        return new FCQueueNodeIterator<E>(this, this.head, this.tail);
    }

    protected synchronized Iterator<FCQueueNode<E>> nodeBackwardIterator() {
        return new FCQueueNodeBackwardIterator<E>(this, this.head, this.tail);
    }

    @Override
    public synchronized Object[] toArray() {
        int size = this.size();
        Object[] result = new Object[size];
        int i = 0;
        for (FCQueueElement e : this) {
            result[i++] = e;
        }
        return result;
    }

    @Override
    public synchronized <T> T[] toArray(T[] a) {
        int size = this.size();
        int i = 0;
        if (a.length < size) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), size);
        } else if (a.length > size) {
            a[size] = null;
        }
        for (FCQueueElement e : this) {
            a[i++] = e;
        }
        return a;
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException("FCQueue allows removal only from the head, not arbitrary removals");
    }

    @Override
    public synchronized boolean containsAll(Collection<?> c) {
        for (Object e : c) {
            if (this.contains(e)) continue;
            return false;
        }
        return true;
    }

    @Override
    public synchronized boolean addAll(Collection<? extends E> c) {
        for (FCQueueElement e : c) {
            this.add((E)e);
        }
        return false;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException("FCQueue can only remove from the head");
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException("FCQueue can only remove from the head");
    }

    @Override
    public synchronized void clear() {
        this.throwIfImmutable();
        ++this.numChanges;
        this.clearInternal();
    }

    private void clearInternal() {
        if (this.head != null) {
            this.head.decRefCount();
            this.head = null;
        }
        if (this.tail != null) {
            this.tail.decRefCount();
            this.tail = null;
        }
        this.size = 0;
        this.runningHashSize = 0;
        this.resetHash();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FCQueue fcQueue = (FCQueue)o;
        return this.size == fcQueue.size && Arrays.equals(this.hash, fcQueue.hash);
    }

    @Override
    public int hashCode() {
        int result = Objects.hash(this.size);
        result = 31 * result + Arrays.hashCode(this.hash);
        return result;
    }

    public synchronized void serialize(SerializableDataOutputStream dos) throws IOException {
        dos.writeInt(this.size());
        dos.write(this.hash);
        dos.writeSerializableIterableWithSize(this.iterator(), this.size(), true, false);
    }

    public synchronized void deserialize(SerializableDataInputStream dis, int version) throws IOException {
        ++this.numChanges;
        byte[] recoveredHash = new byte[this.hash.length];
        int listSize = dis.readInt();
        dis.readFully(recoveredHash);
        dis.readSerializableIterableWithSize(100000000, this::add);
    }

    protected byte[] getHash(E element) {
        if (element == null) {
            return FCQueue.getNullHash();
        }
        Cryptography crypto = CryptoFactory.getInstance();
        crypto.digestSync(element);
        return crypto.digestSync((SelfSerializable)element.getHash()).getValue();
    }

    protected static byte[] getNullHash() {
        return Arrays.copyOf(NULL_HASH, NULL_HASH.length);
    }

    private synchronized void resetHash() {
        System.arraycopy(NULL_HASH, 0, this.hash, 0, this.hash.length);
    }

    public long getClassId() {
        return 139236190103L;
    }

    public int getVersion() {
        return 2;
    }

    public int getMinimumSupportedVersion() {
        return 2;
    }

    private static class ClassVersion {
        public static final int ORIGINAL = 1;
        public static final int MIGRATE_TO_SERIALIZABLE = 2;

        private ClassVersion() {
        }
    }
}

