/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.fcqueue;

import com.swirlds.fcqueue.FCQueue;
import com.swirlds.fcqueue.FCQueueElement;
import com.swirlds.fcqueue.internal.FCQueueNode;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class FCQueueIterator<E extends FCQueueElement>
implements Iterator<E> {
    private FCQueueNode<E> current;
    private final FCQueueNode<E> tail;
    private final FCQueue<E> queue;
    private final int numChanges;

    FCQueueIterator(FCQueue<E> queue, FCQueueNode<E> head, FCQueueNode<E> tail) {
        this.queue = queue;
        this.numChanges = queue.getNumChanges();
        this.current = head;
        this.tail = tail;
    }

    @Override
    public boolean hasNext() {
        return this.current != null;
    }

    @Override
    public E next() {
        FCQueueNode<E> old = this.current;
        if (this.current == null) {
            throw new NoSuchElementException();
        }
        if (this.numChanges != this.queue.getNumChanges()) {
            throw new ConcurrentModificationException();
        }
        this.current = this.current == this.tail ? null : this.current.getTowardTail();
        return (E)((FCQueueElement)old.getElement());
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("FCQueue elements can only be removed at the head");
    }
}

