/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.fcqueue;

import com.swirlds.common.Platform;
import com.swirlds.common.statistics.StatEntry;
import com.swirlds.common.statistics.StatsBuffered;
import com.swirlds.common.statistics.StatsRunningAverage;

public class FCQueueStatistics {
    private static volatile boolean registered;
    private static final double DEFAULT_HALF_LIFE = 10.0;
    protected static final StatsRunningAverage fcqAddExecutionMicros;
    protected static final StatsRunningAverage fcqRemoveExecutionMicros;
    protected static final StatsRunningAverage fcqHashExecutionMicros;
    private static final String FCQUEUE_CATEGORY = "FCQueue";

    private FCQueueStatistics() {
    }

    public static void register(Platform platform) {
        FCQueueStatistics.register(platform, true);
    }

    public static boolean isRegistered() {
        return registered;
    }

    public static void register(Platform platform, boolean includeLocks) {
        platform.addAppStatEntry(new StatEntry(FCQUEUE_CATEGORY, "fcqAddExecMicroSec", "avg time taken to execute the FCQueue add method, not including locks (in microseconds)", "%,9.6f", (StatsBuffered)fcqAddExecutionMicros, h -> {
            fcqAddExecutionMicros.reset(h.doubleValue());
            return fcqAddExecutionMicros;
        }, null, () -> ((StatsRunningAverage)fcqAddExecutionMicros).getWeightedMean()));
        platform.addAppStatEntry(new StatEntry(FCQUEUE_CATEGORY, "fcqRemoveExecMicroSec", "avg time taken to execute the FCQueue remove method, not including locks (in microseconds)", "%,9.6f", (StatsBuffered)fcqRemoveExecutionMicros, h -> {
            fcqRemoveExecutionMicros.reset(h.doubleValue());
            return fcqRemoveExecutionMicros;
        }, null, () -> ((StatsRunningAverage)fcqRemoveExecutionMicros).getWeightedMean()));
        platform.addAppStatEntry(new StatEntry(FCQUEUE_CATEGORY, "fcqHashExecMicroSec", "avg time taken to execute the FCQueue remove method, not including locks (in microseconds)", "%,9.6f", (StatsBuffered)fcqHashExecutionMicros, h -> {
            fcqHashExecutionMicros.reset(h.doubleValue());
            return fcqHashExecutionMicros;
        }, null, () -> ((StatsRunningAverage)fcqHashExecutionMicros).getWeightedMean()));
        registered = true;
    }

    static {
        fcqAddExecutionMicros = new StatsRunningAverage(10.0);
        fcqRemoveExecutionMicros = new StatsRunningAverage(10.0);
        fcqHashExecutionMicros = new StatsRunningAverage(10.0);
    }
}

