/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.fcqueue.internal;

import com.swirlds.common.ByteUtils;

public enum FCQHashAlgorithm {
    SUM_HASH(FCQHashAlgorithm::sumHashCalculator, FCQHashAlgorithm::removalSumHashCalculator),
    ROLLING_HASH(FCQHashAlgorithm::rollingHashCalculator, FCQHashAlgorithm::removalRollingHashCalculator),
    MERKLE_HASH(FCQHashAlgorithm::merkleHashCalculator, FCQHashAlgorithm::removalMerkleHashCalculator);

    public static final long HASH_RADIX = 3L;
    private static final int BYTE_BLOCK = 8;
    private final TriConsumer<byte[], byte[], Integer> hashCalculator;
    private final TriConsumer<byte[], byte[], Integer> removalHashCalculator;

    private FCQHashAlgorithm(TriConsumer<byte[], byte[], Integer> hashCalculator, TriConsumer<byte[], byte[], Integer> removalHashCalculator) {
        this.hashCalculator = hashCalculator;
        this.removalHashCalculator = removalHashCalculator;
    }

    public void computeHash(byte[] hash, byte[] elementHash, int exponent) {
        this.hashCalculator.accept(hash, elementHash, exponent);
    }

    public void computeRemoveHash(byte[] hash, byte[] elementHash, int exponent) {
        this.removalHashCalculator.accept(hash, elementHash, exponent);
    }

    private static void sumHashCalculator(byte[] localHash, byte[] elementHash, int exponent) {
        int carry = 0;
        for (int i = 0; i < localHash.length; ++i) {
            localHash[i] = (byte)(carry += (localHash[i] & 0xFF) + (elementHash[i] & 0xFF));
            carry >>= 8;
        }
    }

    private static void removalSumHashCalculator(byte[] hash, byte[] elementHash, int exponent) {
        int carry = 0;
        for (int i = 0; i < hash.length; ++i) {
            hash[i] = (byte)(carry += (hash[i] & 0xFF) - (elementHash[i] & 0xFF));
            carry >>= 8;
        }
    }

    private static void rollingHashCalculator(byte[] localHash, byte[] elementHash, int exponent) {
        long power = FCQHashAlgorithm.power(3L, exponent);
        for (int i = 0; i < localHash.length; i += 8) {
            long old = ByteUtils.toLong((byte[])localHash, (int)i);
            long elm = ByteUtils.toLong((byte[])elementHash, (int)i);
            long value = old + power * elm;
            ByteUtils.toBytes((long)value, (byte[])localHash, (int)i);
        }
    }

    private static void removalRollingHashCalculator(byte[] hash, byte[] elementHash, int exponent) {
        long power = FCQHashAlgorithm.power(3L, exponent);
        for (int i = 0; i < hash.length; i += 8) {
            long old = ByteUtils.toLong((byte[])hash, (int)i);
            long elm = ByteUtils.toLong((byte[])elementHash, (int)i);
            long value = old - power * elm;
            ByteUtils.toBytes((long)value, (byte[])hash, (int)i);
        }
    }

    public static void increaseRollingBase(int power, byte[] localHash) {
        long factor = FCQHashAlgorithm.power(3L, power);
        for (int i = 0; i < localHash.length; i += 8) {
            long old = ByteUtils.toLong((byte[])localHash, (int)i);
            long value = old * factor;
            ByteUtils.toBytes((long)value, (byte[])localHash, (int)i);
        }
    }

    private static void merkleHashCalculator(byte[] hash, byte[] elementHash, int exponent) {
        throw new UnsupportedOperationException("Hash algorithm Merkle is not supported");
    }

    private static void removalMerkleHashCalculator(byte[] hash, byte[] elementHash, int exponent) {
        throw new UnsupportedOperationException("Hash algorithm Merkle is not supported");
    }

    private static long power(long x, long y) {
        long res = 1L;
        while (y > 0L) {
            if ((y & 1L) == 1L) {
                res *= x;
            }
            y >>= 1;
            x *= x;
        }
        return res;
    }

    @FunctionalInterface
    static interface TriConsumer<A, B, C> {
        public void accept(A var1, B var2, C var3);
    }
}

