/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.fcqueue.internal;

import com.swirlds.common.FastCopyable;

public class FCQueueNode<E extends FastCopyable> {
    private final E element;
    private long refCount = 2L;
    private FCQueueNode<E> towardHead = null;
    private FCQueueNode<E> towardTail = null;
    private byte[] elementHashOfHash;
    private static final int INITIAL_REFCOUNT = 2;

    public FCQueueNode(E element) {
        this.element = element;
    }

    public E getElement() {
        return this.element;
    }

    public long getRefCount() {
        return this.refCount;
    }

    public FCQueueNode<E> getTowardHead() {
        return this.towardHead;
    }

    public void setTowardHead(FCQueueNode<E> towardHead) {
        this.towardHead = towardHead;
    }

    public FCQueueNode<E> getTowardTail() {
        return this.towardTail;
    }

    public void setTowardTail(FCQueueNode<E> towardTail) {
        this.towardTail = towardTail;
    }

    public synchronized byte[] getElementHashOfHash() {
        return this.elementHashOfHash;
    }

    public synchronized void setElementHashOfHash(byte[] elementHashOfHash) {
        this.elementHashOfHash = elementHashOfHash;
    }

    public FCQueueNode<E> insertAtTail(E element) {
        if (this.towardTail != null) {
            throw new IllegalArgumentException("FCQueue tried to insert somewhere other than the tail");
        }
        FCQueueNode<E> node = new FCQueueNode<E>(element);
        node.refCount = 1L;
        node.towardHead = this;
        node.towardTail = null;
        this.towardTail = node;
        return node;
    }

    public synchronized long incRefCount() {
        ++this.refCount;
        return this.refCount;
    }

    public synchronized long decRefCount() {
        --this.refCount;
        FCQueueNode<E> q = this;
        while (q != null && q.refCount == 0L && q.towardHead == null) {
            if (q.towardTail != null) {
                q.towardTail.towardHead = null;
            }
            q = q.towardTail;
        }
        q = this;
        while (q != null && q.refCount == 0L && q.towardTail == null) {
            if (q.towardHead != null) {
                q.towardHead.towardTail = null;
            }
            q = q.towardHead;
        }
        return this.refCount;
    }
}

