/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.fcqueue.internal;

import com.swirlds.fcqueue.FCQueue;
import com.swirlds.fcqueue.FCQueueElement;
import com.swirlds.fcqueue.internal.FCQueueNode;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class FCQueueNodeIterator<E extends FCQueueElement>
implements Iterator<FCQueueNode<E>> {
    protected FCQueueNode<E> current;
    private final FCQueueNode<E> stopNode;
    private final FCQueue<E> queue;
    private final int numChanges;

    public FCQueueNodeIterator(FCQueue<E> queue, FCQueueNode<E> head, FCQueueNode<E> tail) {
        this.queue = queue;
        this.numChanges = queue.getNumChanges();
        this.current = head;
        this.stopNode = tail;
    }

    @Override
    public boolean hasNext() {
        return this.current != null;
    }

    @Override
    public FCQueueNode<E> next() {
        FCQueueNode<E> old = this.current;
        if (this.current == null) {
            throw new NoSuchElementException();
        }
        if (this.numChanges != this.queue.getNumChanges()) {
            throw new ConcurrentModificationException();
        }
        this.current = this.current == this.stopNode ? null : this.nextNode();
        return old;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("FCQueue elements can only be removed at the head");
    }

    FCQueueNode<E> nextNode() {
        return this.current.getTowardTail();
    }
}

