/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.logging;

import com.swirlds.logging.SwirldsLogParser;
import com.swirlds.logging.SwirldsLogReader;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;

public class SwirldsLogFileReader<T>
extends SwirldsLogReader<T> {
    private final SwirldsLogParser<T> parser;
    private final BufferedReader fileReader;

    public SwirldsLogFileReader(File logFile, SwirldsLogParser<T> parser) throws FileNotFoundException {
        this.parser = parser;
        this.fileReader = new BufferedReader(new InputStreamReader(new FileInputStream(logFile)));
    }

    @Override
    protected T readNextEntry() throws IOException {
        T entry;
        String line;
        do {
            if ((line = this.fileReader.readLine()) != null) continue;
            return null;
        } while (line.strip().isEmpty() || (entry = this.parser.parse(line)) == null);
        return entry;
    }
}

