/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.logging.json;

import com.swirlds.logging.json.JsonLogEntry;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;

public class HasExceptionFilter
implements Predicate<JsonLogEntry> {
    private final Set<String> exceptionTypes;

    public static HasExceptionFilter hasException(String ... exceptionTypes) {
        HashSet<String> set = new HashSet<String>();
        Collections.addAll(set, exceptionTypes);
        return new HasExceptionFilter(set);
    }

    public static HasExceptionFilter hasException(List<String> exceptionTypes) {
        return new HasExceptionFilter(new HashSet<String>(exceptionTypes));
    }

    public static HasExceptionFilter hasException(Set<String> exceptionTypes) {
        return new HasExceptionFilter(exceptionTypes);
    }

    public HasExceptionFilter(Set<String> exceptionTypes) {
        this.exceptionTypes = exceptionTypes;
    }

    @Override
    public boolean test(JsonLogEntry entry) {
        if (!entry.hasException() || this.exceptionTypes == null) {
            return false;
        }
        return this.exceptionTypes.contains(entry.getExceptionType());
    }
}

