/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.logging.json;

import com.swirlds.logging.json.JsonLogEntry;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;

public class HasMarkerFilter
implements Predicate<JsonLogEntry> {
    private final Set<String> markers;

    public static HasMarkerFilter hasMarker(String ... markers) {
        HashSet<String> set = new HashSet<String>();
        Collections.addAll(set, markers);
        return new HasMarkerFilter(set);
    }

    public static HasMarkerFilter hasMarker(List<String> markerNames) {
        return new HasMarkerFilter(new HashSet<String>(markerNames));
    }

    public static HasMarkerFilter hasMarker(Set<String> markerNames) {
        return new HasMarkerFilter(markerNames);
    }

    public HasMarkerFilter(Set<String> markers) {
        this.markers = markers;
    }

    @Override
    public boolean test(JsonLogEntry entry) {
        if (this.markers == null) {
            return false;
        }
        return this.markers.contains(entry.getMarker());
    }
}

