/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.logging.json;

import com.swirlds.logging.json.JsonLogEntry;
import com.swirlds.logging.payloads.AbstractLogPayload;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;

public class PayloadTypeFilter
implements Predicate<JsonLogEntry> {
    private final Set<String> types;

    public static PayloadTypeFilter payloadType(String ... types) {
        HashSet<String> set = new HashSet<String>();
        Collections.addAll(set, types);
        return new PayloadTypeFilter(set);
    }

    public static PayloadTypeFilter payloadType(List<String> types) {
        return new PayloadTypeFilter(new HashSet<String>(types));
    }

    public static PayloadTypeFilter payloadType(Set<String> types) {
        return new PayloadTypeFilter(types);
    }

    public PayloadTypeFilter(Set<String> types) {
        this.types = types;
    }

    @Override
    public boolean test(JsonLogEntry entry) {
        if (this.types == null) {
            return false;
        }
        String type = AbstractLogPayload.extractPayloadType(entry.getRawPayload());
        return this.types.stream().anyMatch(type::contains);
    }
}

