/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.logging.v2.extensions.event;

import com.swirlds.logging.v2.Level;
import com.swirlds.logging.v2.Marker;
import com.swirlds.logging.v2.extensions.event.LogMessage;
import com.swirlds.logging.v2.extensions.event.SimpleLogMessage;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.time.Instant;
import java.util.Map;

public record LogEvent(@NonNull Level level, @NonNull String loggerName, @NonNull String threadName, @NonNull Instant timestamp, @NonNull LogMessage message, @Nullable Throwable throwable, @Nullable Marker marker, @NonNull Map<String, String> context) {
    public LogEvent(@NonNull Level level, @NonNull String loggerName, @NonNull String threadName, @NonNull Instant timestamp, @NonNull String message, @Nullable Throwable throwable, @Nullable Marker marker, @NonNull Map<String, String> context) {
        this(level, loggerName, threadName, timestamp, new SimpleLogMessage(message), throwable, marker, context);
    }

    public LogEvent(@NonNull Level level, @NonNull String loggerName, @NonNull String message) {
        this(level, loggerName, message, null);
    }

    public LogEvent(@NonNull Level level, @NonNull String loggerName, @NonNull String message, @Nullable Throwable throwable) {
        this(level, loggerName, Thread.currentThread().getName(), Instant.now(), new SimpleLogMessage(message), throwable, null, Map.of());
    }

    @NonNull
    public static LogEvent createCopyWithDifferentContext(@NonNull LogEvent logEvent, @NonNull Map<String, String> context) {
        return new LogEvent(logEvent.level, logEvent.loggerName, logEvent.threadName, logEvent.timestamp, logEvent.message, logEvent.throwable, logEvent.marker, context);
    }

    @NonNull
    public static LogEvent createCopyWithDifferentName(@NonNull LogEvent logEvent, @NonNull String loggerName) {
        return new LogEvent(logEvent.level, loggerName, logEvent.threadName, logEvent.timestamp, logEvent.message, logEvent.throwable, logEvent.marker, logEvent.context);
    }
}

