/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.logging.v2.internal.format;

import com.swirlds.logging.v2.Level;
import com.swirlds.logging.v2.Marker;
import com.swirlds.logging.v2.extensions.emergency.EmergencyLogger;
import com.swirlds.logging.v2.extensions.emergency.EmergencyLoggerProvider;
import com.swirlds.logging.v2.extensions.event.LogEvent;
import com.swirlds.logging.v2.extensions.event.LogMessage;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.PrintWriter;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Map;
import java.util.Objects;

public class LineBasedFormat {
    private static final EmergencyLogger EMERGENCY_LOGGER = EmergencyLoggerProvider.getEmergencyLogger();
    private final DateTimeFormatter formatter = DateTimeFormatter.ISO_LOCAL_DATE_TIME.withZone(ZoneId.systemDefault());
    private final PrintWriter printWriter;

    public LineBasedFormat(@NonNull PrintWriter printWriter) {
        this.printWriter = Objects.requireNonNull(printWriter, "printWriter must not be null");
    }

    public void print(@NonNull LogEvent event) {
        Map<String, String> context;
        if (event == null) {
            EMERGENCY_LOGGER.logNPE("event");
        }
        this.printWriter.print(this.asString(event.timestamp()));
        this.printWriter.print(' ');
        this.printWriter.print(this.asString(event.level()));
        this.printWriter.print(' ');
        this.printWriter.print('[');
        this.printWriter.print(this.asString(event.threadName(), "THREAD"));
        this.printWriter.print(']');
        this.printWriter.print(' ');
        this.printWriter.print(this.asString(event.loggerName(), "LOGGER"));
        this.printWriter.print(" - ");
        this.printWriter.print(this.asString(event.message()));
        Marker marker = event.marker();
        if (marker != null) {
            this.printWriter.print(" - M:");
            this.printWriter.print(this.asString(marker));
        }
        if ((context = event.context()) != null && !context.isEmpty()) {
            this.printWriter.print(" - C:");
            this.printWriter.print(context);
        }
        this.printWriter.println();
        Throwable throwable = event.throwable();
        if (throwable != null) {
            throwable.printStackTrace(this.printWriter);
        }
    }

    @NonNull
    private String asString(@Nullable String str, @NonNull String suffix) {
        if (str == null) {
            return "UNDEFINED-" + suffix;
        }
        return str;
    }

    @NonNull
    private String asString(@Nullable Level level) {
        if (level == null) {
            return "UNDEFINED";
        }
        return level.name();
    }

    @NonNull
    private String asString(@Nullable LogMessage message) {
        if (message == null) {
            return "UNDEFINED-MESSAGE";
        }
        try {
            return message.getMessage();
        }
        catch (Throwable e) {
            EMERGENCY_LOGGER.log(Level.ERROR, "Failed to format message", e);
            return "BROKEN-MESSAGE";
        }
    }

    @NonNull
    private String asString(@Nullable Instant instant) {
        if (instant == null) {
            return "UNDEFINED-TIMESTAMP       ";
        }
        try {
            return this.formatter.format(instant);
        }
        catch (Throwable e) {
            EMERGENCY_LOGGER.log(Level.ERROR, "Failed to format instant", e);
            return "BROKEN-TIMESTAMP          ";
        }
    }

    @NonNull
    private String asString(@Nullable Marker marker) {
        if (marker == null) {
            return "null";
        }
        Marker parent = marker.parent();
        if (parent == null) {
            return "Marker{name='" + marker.name() + "'}";
        }
        return "Marker{name='" + marker.name() + "', parent='" + this.asString(parent) + "'}";
    }
}

