/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.logging;

import com.swirlds.logging.extensions.emergency.EmergencyLogger;
import com.swirlds.logging.extensions.emergency.EmergencyLoggerProvider;
import edu.umd.cs.findbugs.annotations.NonNull;

public enum Level {
    ERROR(10),
    WARN(20),
    INFO(30),
    DEBUG(40),
    TRACE(100);

    private static final EmergencyLogger EMERGENCY_LOGGER;
    private final int levelOrdinal;

    private Level(int levelOrdinal) {
        this.levelOrdinal = levelOrdinal;
    }

    public boolean enabledLoggingOfLevel(@NonNull Level level) {
        if (level == null) {
            EMERGENCY_LOGGER.logNPE("level");
            return true;
        }
        return this.levelOrdinal >= level.levelOrdinal;
    }

    static {
        EMERGENCY_LOGGER = EmergencyLoggerProvider.getEmergencyLogger();
    }
}

