/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.logging.internal.emergency;

import com.swirlds.logging.Level;
import com.swirlds.logging.extensions.emergency.EmergencyLogger;
import com.swirlds.logging.extensions.event.LogEvent;
import com.swirlds.logging.internal.format.LineBasedFormat;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.function.Supplier;

public class EmergencyLoggerImpl
implements EmergencyLogger {
    private static final String EMERGENCY_LOGGER_NAME = "EMERGENCY-LOGGER";
    private static final String UNDEFINED_MESSAGE = "UNDEFINED-MESSAGE";
    private static final int LOG_EVENT_QUEUE_SIZE = 1000;
    private static final String LEVEL_PROPERTY_NAME = "com.swirlds.logging.emergency.level";
    private static final EmergencyLoggerImpl INSTANCE = new EmergencyLoggerImpl();
    private final Level supportedLevel;
    private final ArrayBlockingQueue<LogEvent> logEvents = new ArrayBlockingQueue(1000);
    private final ThreadLocal<Boolean> recursionGuard = new ThreadLocal();

    private EmergencyLoggerImpl() {
        this.supportedLevel = EmergencyLoggerImpl.getSupportedLevelFromSystemProperties();
    }

    @NonNull
    private static Level getSupportedLevelFromSystemProperties() {
        String property = System.getProperty(LEVEL_PROPERTY_NAME);
        if (property == null) {
            return Level.DEBUG;
        }
        if (Objects.equals(property.toUpperCase(), Level.TRACE.name())) {
            return Level.TRACE;
        }
        if (Objects.equals(property.toUpperCase(), Level.DEBUG.name())) {
            return Level.DEBUG;
        }
        if (Objects.equals(property.toUpperCase(), Level.INFO.name())) {
            return Level.INFO;
        }
        if (Objects.equals(property.toUpperCase(), Level.WARN.name())) {
            return Level.WARN;
        }
        if (Objects.equals(property.toUpperCase(), Level.ERROR.name())) {
            return Level.ERROR;
        }
        return Level.TRACE;
    }

    @Override
    public void logNPE(@NonNull String nameOfNullParam) {
        this.log(Level.ERROR, "Null parameter: " + nameOfNullParam, new NullPointerException("Null parameter: " + nameOfNullParam));
    }

    @Override
    public void log(@NonNull Level level, @NonNull String message, @Nullable Throwable thrown) {
        if (level == null && message == null) {
            this.log(new LogEvent(Level.ERROR, EMERGENCY_LOGGER_NAME, UNDEFINED_MESSAGE, thrown));
        } else if (level == null) {
            this.log(new LogEvent(Level.ERROR, EMERGENCY_LOGGER_NAME, message, thrown));
        } else if (message == null) {
            this.log(new LogEvent(level, EMERGENCY_LOGGER_NAME, UNDEFINED_MESSAGE, thrown));
        } else {
            this.log(new LogEvent(level, EMERGENCY_LOGGER_NAME, message, thrown));
        }
    }

    @Override
    public void log(@NonNull LogEvent event) {
        if (event == null) {
            this.logNPE("event");
            return;
        }
        if (this.isLoggable(event.level())) {
            this.callGuarded(event, () -> this.handle(event));
        }
    }

    private boolean isLoggable(@NonNull Level level) {
        if (level == null) {
            this.logNPE("level");
            return true;
        }
        return this.supportedLevel.enabledLoggingOfLevel(level);
    }

    private void callGuarded(@NonNull LogEvent fallbackLogEvent, @NonNull Runnable task) {
        this.callGuarded(fallbackLogEvent, null, () -> {
            task.run();
            return null;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private <T> T callGuarded(@Nullable LogEvent fallbackLogEvent, @Nullable T fallbackValue, @NonNull Supplier<T> supplier) {
        Boolean guard = this.recursionGuard.get();
        if (guard != null && guard.booleanValue()) {
            LogEvent logEvent = new LogEvent(Level.ERROR, EMERGENCY_LOGGER_NAME, "Recursion in Emergency logger", new IllegalStateException("Recursion in Emergency logger"));
            this.handle(logEvent);
            if (fallbackLogEvent != null) {
                this.handle(fallbackLogEvent);
            }
            return fallbackValue;
        }
        this.recursionGuard.set(true);
        try {
            T logEvent = supplier.get();
            return logEvent;
        }
        catch (Throwable t) {
            LogEvent logEvent = new LogEvent(Level.ERROR, EMERGENCY_LOGGER_NAME, "Error in Emergency logger", t);
            this.handle(logEvent);
            if (fallbackLogEvent != null) {
                this.handle(fallbackLogEvent);
            }
            T t2 = fallbackValue;
            return t2;
        }
        finally {
            this.recursionGuard.set(false);
        }
    }

    private void handle(@NonNull LogEvent logEvent) {
        if (logEvent == null) {
            this.logNPE("logEvent");
            return;
        }
        PrintStream printStream = Optional.ofNullable(System.err).orElse(System.out);
        if (printStream != null) {
            new LineBasedFormat(new PrintWriter(printStream, true)).print(logEvent);
        }
        if (this.logEvents.remainingCapacity() == 0) {
            this.logEvents.remove();
        }
        this.logEvents.add(logEvent);
    }

    @NonNull
    public List<LogEvent> publishLoggedEvents() {
        List<LogEvent> result = List.copyOf(this.logEvents);
        this.logEvents.clear();
        return result;
    }

    @NonNull
    public static EmergencyLoggerImpl getInstance() {
        return INSTANCE;
    }
}

