/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.logging.api;

import com.swirlds.logging.api.extensions.emergency.EmergencyLogger;
import com.swirlds.logging.api.extensions.emergency.EmergencyLoggerProvider;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;

public enum Level {
    OFF(0),
    ERROR(10),
    WARN(20),
    INFO(30),
    DEBUG(40),
    TRACE(100);

    private static final EmergencyLogger EMERGENCY_LOGGER;
    private final int levelOrdinal;

    private Level(int levelOrdinal) {
        this.levelOrdinal = levelOrdinal;
    }

    public boolean enabledLoggingOfLevel(@NonNull Level level) {
        if (level == null) {
            EMERGENCY_LOGGER.logNPE("level");
            return true;
        }
        return this.levelOrdinal >= level.levelOrdinal;
    }

    public static Level valueOfOrElse(@Nullable String value, @NonNull Level defaultLevel) {
        if (defaultLevel == null) {
            EMERGENCY_LOGGER.logNPE("defaultLevel");
            return Level.valueOfOrElse(value, INFO);
        }
        try {
            return Level.valueOf(value);
        }
        catch (IllegalArgumentException e) {
            EMERGENCY_LOGGER.log(ERROR, "Invalid log level: " + value, e);
            return defaultLevel;
        }
    }

    static {
        EMERGENCY_LOGGER = EmergencyLoggerProvider.getEmergencyLogger();
    }
}

