/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.logging.api;

import com.swirlds.logging.api.Logger;
import com.swirlds.logging.api.extensions.emergency.EmergencyLogger;
import com.swirlds.logging.api.extensions.emergency.EmergencyLoggerProvider;
import com.swirlds.logging.api.internal.DefaultLoggingSystem;
import edu.umd.cs.findbugs.annotations.NonNull;

public final class Loggers {
    private static final EmergencyLogger EMERGENCY_LOGGER = EmergencyLoggerProvider.getEmergencyLogger();

    @NonNull
    public static Logger getLogger(@NonNull String name) {
        if (name == null) {
            EMERGENCY_LOGGER.logNPE("name");
            return Loggers.getLogger("");
        }
        return DefaultLoggingSystem.getInstance().getLogger(name);
    }

    @NonNull
    public static Logger getLogger(@NonNull Class<?> clazz) {
        if (clazz == null) {
            EMERGENCY_LOGGER.logNPE("clazz");
            return Loggers.getLogger("");
        }
        return Loggers.getLogger(clazz.getName());
    }
}

