/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.logging.api.extensions.handler;

import com.swirlds.config.api.Configuration;
import com.swirlds.logging.api.Level;
import com.swirlds.logging.api.Marker;
import com.swirlds.logging.api.extensions.handler.LogHandler;
import com.swirlds.logging.api.internal.level.HandlerLoggingLevelConfig;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;

public abstract class AbstractLogHandler
implements LogHandler {
    private static final String PROPERTY_HANDLER = "logging.handler.%s";
    private static final String PROPERTY_HANDLER_ENABLED = "logging.handler.%s.enabled";
    private static final String PROPERTY_HANDLER_LEVEL = "logging.handler.%s.level";
    private final String configKey;
    private final Configuration configuration;
    private final HandlerLoggingLevelConfig loggingLevelConfig;

    public AbstractLogHandler(@NonNull String configKey, @NonNull Configuration configuration) {
        this.configKey = Objects.requireNonNull(configKey, "configKey must not be null");
        this.configuration = Objects.requireNonNull(configuration, "configuration must not be null");
        this.loggingLevelConfig = new HandlerLoggingLevelConfig(configuration, configKey);
    }

    @Override
    public boolean isActive() {
        return Boolean.TRUE.equals(this.configuration.getValue(PROPERTY_HANDLER_ENABLED.formatted(this.configKey), Boolean.class, (Object)false));
    }

    @Override
    public boolean isEnabled(@NonNull String name, @NonNull Level level, @Nullable Marker marker) {
        return this.loggingLevelConfig.isEnabled(name, level, marker);
    }

    @NonNull
    protected Configuration getConfiguration() {
        return this.configuration;
    }
}

