/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.logging.api.extensions.handler;

import com.swirlds.config.api.Configuration;
import com.swirlds.logging.api.extensions.emergency.EmergencyLogger;
import com.swirlds.logging.api.extensions.emergency.EmergencyLoggerProvider;
import com.swirlds.logging.api.extensions.event.LogEvent;
import com.swirlds.logging.api.extensions.handler.AbstractLogHandler;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public abstract class AbstractSyncedHandler
extends AbstractLogHandler {
    private static final EmergencyLogger EMERGENCY_LOGGER = EmergencyLoggerProvider.getEmergencyLogger();
    private final Lock writeLock = new ReentrantLock();
    private volatile boolean stopped = false;

    public AbstractSyncedHandler(@NonNull String configKey, @NonNull Configuration configuration) {
        super(configKey, configuration);
    }

    @Override
    public final void accept(@NonNull LogEvent event) {
        try {
            this.writeLock.lock();
            if (this.stopped) {
                EMERGENCY_LOGGER.log(event);
            } else {
                this.handleEvent(event);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    protected abstract void handleEvent(@NonNull LogEvent var1);

    @Override
    public final void stopAndFinalize() {
        try {
            this.writeLock.lock();
            this.stopped = true;
            this.handleStopAndFinalize();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    protected void handleStopAndFinalize() {
    }
}

