/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.logging.api.internal;

import com.swirlds.config.api.Configuration;
import com.swirlds.config.api.ConfigurationBuilder;
import com.swirlds.config.api.converter.ConfigConverter;
import com.swirlds.config.api.source.ConfigSource;
import com.swirlds.config.extensions.sources.PropertyFileConfigSource;
import com.swirlds.logging.api.Level;
import com.swirlds.logging.api.Logger;
import com.swirlds.logging.api.extensions.emergency.EmergencyLogger;
import com.swirlds.logging.api.extensions.emergency.EmergencyLoggerProvider;
import com.swirlds.logging.api.extensions.handler.LogHandler;
import com.swirlds.logging.api.extensions.handler.LogHandlerFactory;
import com.swirlds.logging.api.extensions.provider.LogProvider;
import com.swirlds.logging.api.extensions.provider.LogProviderFactory;
import com.swirlds.logging.api.internal.LoggingSystem;
import com.swirlds.logging.api.internal.configuration.ConfigLevelConverter;
import com.swirlds.logging.api.internal.configuration.MarkerStateConverter;
import com.swirlds.logging.api.internal.emergency.EmergencyLoggerImpl;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.concurrent.atomic.AtomicBoolean;

public class DefaultLoggingSystem {
    private static final String ENV_PROPERTY_LOG_PATH = "LOG_CONFIG_PATH";
    private static final EmergencyLogger EMERGENCY_LOGGER = EmergencyLoggerProvider.getEmergencyLogger();
    private static final AtomicBoolean INITIALIZED = new AtomicBoolean(false);
    private final LoggingSystem internalLoggingSystem;

    private DefaultLoggingSystem() {
        try {
            Configuration configuration = DefaultLoggingSystem.createConfiguration();
            this.internalLoggingSystem = new LoggingSystem(configuration);
            this.installHandlers(configuration);
            this.installProviders(configuration);
            EmergencyLoggerImpl.getInstance().publishLoggedEvents().stream().map(event -> this.internalLoggingSystem.getLogEventFactory().createLogEvent(event.level(), "EMERGENCY-LOGGER-QUEUE", event.threadName(), event.timestamp(), event.message(), event.throwable(), event.marker(), event.context())).forEach(this.internalLoggingSystem::accept);
            INITIALIZED.set(true);
        }
        catch (Exception e) {
            EMERGENCY_LOGGER.log(Level.ERROR, "Unable to initialize logging system", e);
            throw e;
        }
    }

    @NonNull
    private static Configuration createConfiguration() {
        String logConfigPath = System.getenv(ENV_PROPERTY_LOG_PATH);
        Path configFilePath = Optional.ofNullable(logConfigPath).map(x$0 -> Path.of(x$0, new String[0])).orElseGet(() -> Path.of("log.properties", new String[0]));
        try {
            PropertyFileConfigSource configSource = new PropertyFileConfigSource(configFilePath);
            return ConfigurationBuilder.create().withSource((ConfigSource)configSource).withConverter((ConfigConverter)new MarkerStateConverter()).withConverter((ConfigConverter)new ConfigLevelConverter()).build();
        }
        catch (IOException e) {
            EMERGENCY_LOGGER.log(Level.WARN, "Unable to load logging configuration from path: '%s'. Using default configuration.".formatted(configFilePath));
            return ConfigurationBuilder.create().build();
        }
    }

    private void installHandlers(@NonNull Configuration configuration) {
        ServiceLoader<LogHandlerFactory> serviceLoader = ServiceLoader.load(LogHandlerFactory.class);
        List<LogHandler> handlers = serviceLoader.stream().map(ServiceLoader.Provider::get).map(factory -> factory.create(configuration)).filter(LogHandler::isActive).toList();
        handlers.forEach(this.internalLoggingSystem::addHandler);
        EMERGENCY_LOGGER.log(Level.DEBUG, handlers.size() + " logging handlers installed: " + String.valueOf(handlers));
    }

    private void installProviders(@NonNull Configuration configuration) {
        ServiceLoader<LogProviderFactory> serviceLoader = ServiceLoader.load(LogProviderFactory.class);
        List<LogProvider> providers = serviceLoader.stream().map(ServiceLoader.Provider::get).map(factory -> factory.create(configuration)).filter(LogProvider::isActive).toList();
        providers.forEach(p -> p.install(this.internalLoggingSystem.getLogEventFactory(), this.internalLoggingSystem));
        EMERGENCY_LOGGER.log(Level.DEBUG, providers.size() + " logging providers installed: " + String.valueOf(providers));
    }

    @NonNull
    public static DefaultLoggingSystem getInstance() {
        return InstanceHolder.INSTANCE;
    }

    @NonNull
    public Logger getLogger(@NonNull String loggerName) {
        return this.internalLoggingSystem.getLogger(loggerName);
    }

    public void addHandler(@NonNull LogHandler logHandler) {
        this.internalLoggingSystem.addHandler(logHandler);
    }

    public void removeHandler(@NonNull LogHandler logHandler) {
        this.internalLoggingSystem.removeHandler(logHandler);
    }

    public static boolean isInitialized() {
        return INITIALIZED.get();
    }

    private static class InstanceHolder {
        private static final DefaultLoggingSystem INSTANCE = new DefaultLoggingSystem();

        private InstanceHolder() {
        }
    }
}

