/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.logging.api.internal;

import com.swirlds.logging.api.Level;
import com.swirlds.logging.api.Logger;
import com.swirlds.logging.api.Marker;
import com.swirlds.logging.api.extensions.emergency.EmergencyLogger;
import com.swirlds.logging.api.extensions.emergency.EmergencyLoggerProvider;
import com.swirlds.logging.api.extensions.event.LogEvent;
import com.swirlds.logging.api.extensions.event.LogEventConsumer;
import com.swirlds.logging.api.extensions.event.LogEventFactory;
import com.swirlds.logging.api.extensions.event.LogMessage;
import com.swirlds.logging.api.internal.event.ParameterizedLogMessage;
import com.swirlds.logging.api.internal.event.SimpleLogMessage;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class LoggerImpl
implements Logger {
    private static final EmergencyLogger EMERGENCY_LOGGER = EmergencyLoggerProvider.getEmergencyLogger();
    private final String name;
    private final Marker marker;
    private final Map<String, String> context;
    private final LogEventConsumer logEventConsumer;
    private final LogEventFactory logEventFactory;

    protected LoggerImpl(@NonNull String name, @Nullable Marker marker, @NonNull Map<String, String> context, @NonNull LogEventFactory logEventFactory, @NonNull LogEventConsumer logEventConsumer) {
        if (name == null) {
            EMERGENCY_LOGGER.logNPE("name");
            this.name = "";
        } else {
            this.name = name;
        }
        this.marker = marker;
        this.context = context == null ? Collections.emptyMap() : Collections.unmodifiableMap(context);
        this.logEventFactory = Objects.requireNonNull(logEventFactory, "logEventFactory must not be null");
        this.logEventConsumer = Objects.requireNonNull(logEventConsumer, "logEventConsumer must not be null");
    }

    public LoggerImpl(@NonNull String name, @NonNull LogEventFactory logEventFactory, @NonNull LogEventConsumer logEventConsumer) {
        this(name, null, Map.of(), logEventFactory, logEventConsumer);
    }

    @Override
    @NonNull
    public String getName() {
        return this.name;
    }

    @Override
    public void log(@NonNull Level level, @NonNull String message) {
        this.log(level, message, null);
    }

    @Override
    public void log(@NonNull Level level, @NonNull String message, @Nullable Throwable throwable) {
        this.logImpl(level, new SimpleLogMessage(message), throwable);
    }

    @Override
    public void log(@NonNull Level level, @NonNull String message, Object ... args) {
        this.logImpl(level, new ParameterizedLogMessage(message, args), null);
    }

    @Override
    public void log(@NonNull Level level, @NonNull String message, @Nullable Object arg) {
        this.logImpl(level, new ParameterizedLogMessage(message, arg), null);
    }

    @Override
    public void log(@NonNull Level level, @NonNull String message, @Nullable Object arg1, @Nullable Object arg2) {
        this.logImpl(level, new ParameterizedLogMessage(message, arg1, arg2), null);
    }

    @Override
    public void log(@NonNull Level level, @NonNull String message, @Nullable Throwable throwable, Object ... args) {
        this.logImpl(level, new ParameterizedLogMessage(message, args), throwable);
    }

    @Override
    public void log(@NonNull Level level, @NonNull String message, @Nullable Throwable throwable, @Nullable Object arg1) {
        this.logImpl(level, new ParameterizedLogMessage(message, arg1), throwable);
    }

    @Override
    public void log(@NonNull Level level, @NonNull String message, @Nullable Throwable throwable, @Nullable Object arg1, @Nullable Object arg2) {
        this.logImpl(level, new ParameterizedLogMessage(message, arg1, arg2), throwable);
    }

    @Override
    @NonNull
    public Logger withMarker(@NonNull String markerName) {
        if (markerName == null) {
            EMERGENCY_LOGGER.logNPE("markerName");
            return this;
        }
        return this.withMarkerAndContext(new Marker(markerName, this.marker), this.context);
    }

    @Override
    @NonNull
    public Logger withContext(@NonNull String key, @Nullable String value) {
        if (key == null) {
            EMERGENCY_LOGGER.logNPE("key");
            return this;
        }
        HashMap<String, String> newContext = new HashMap<String, String>(this.context);
        newContext.put(key, value);
        return this.withMarkerAndContext(this.marker, newContext);
    }

    @Override
    @NonNull
    public Logger withContext(@NonNull String key, String ... values) {
        if (values == null) {
            EMERGENCY_LOGGER.logNPE("values");
            return this.withContext(key, (String)null);
        }
        if (key == null) {
            EMERGENCY_LOGGER.logNPE("key");
            return this;
        }
        HashMap<String, String> newContext = new HashMap<String, String>(this.context);
        newContext.put(key, String.join((CharSequence)",", values));
        return this.withMarkerAndContext(this.marker, newContext);
    }

    @Override
    public boolean isEnabled(@NonNull Level level) {
        return this.logEventConsumer.isEnabled(this.getName(), level, this.marker);
    }

    @NonNull
    protected Logger withMarkerAndContext(@Nullable Marker marker, @NonNull Map<String, String> context) {
        return new LoggerImpl(this.getName(), marker, context, this.logEventFactory, this.logEventConsumer);
    }

    public void logImpl(@NonNull Level level, @NonNull LogMessage message, @Nullable Throwable throwable) {
        if (this.isEnabled(level)) {
            Marker marker = this.marker;
            LogEvent logEvent = this.logEventFactory.createLogEvent(level, this.getName(), message, throwable, marker, this.context);
            this.logEventConsumer.accept(logEvent);
        }
    }
}

