/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.logging.api.internal;

import com.swirlds.config.api.Configuration;
import com.swirlds.logging.api.Level;
import com.swirlds.logging.api.Marker;
import com.swirlds.logging.api.extensions.emergency.EmergencyLogger;
import com.swirlds.logging.api.extensions.emergency.EmergencyLoggerProvider;
import com.swirlds.logging.api.extensions.event.LogEvent;
import com.swirlds.logging.api.extensions.event.LogEventConsumer;
import com.swirlds.logging.api.extensions.event.LogEventFactory;
import com.swirlds.logging.api.extensions.handler.LogHandler;
import com.swirlds.logging.api.internal.LoggerImpl;
import com.swirlds.logging.api.internal.event.SimpleLogEventFactory;
import com.swirlds.logging.api.internal.level.HandlerLoggingLevelConfig;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;

public class LoggingSystem
implements LogEventConsumer {
    private static final EmergencyLogger EMERGENCY_LOGGER = EmergencyLoggerProvider.getEmergencyLogger();
    public static final String ROOT_LOGGER_NAME = "";
    private final List<LogHandler> handlers;
    private final Map<String, LoggerImpl> loggers;
    private final HandlerLoggingLevelConfig levelConfig;
    private final LogEventFactory logEventFactory = new SimpleLogEventFactory();

    public LoggingSystem(@NonNull Configuration configuration) {
        Objects.requireNonNull(configuration, "configuration must not be null");
        this.levelConfig = new HandlerLoggingLevelConfig(configuration);
        this.loggers = new ConcurrentHashMap<String, LoggerImpl>();
        this.handlers = new CopyOnWriteArrayList<LogHandler>();
    }

    public void addHandler(@NonNull LogHandler handler) {
        if (handler == null) {
            EMERGENCY_LOGGER.logNPE("handler");
        } else {
            this.handlers.add(handler);
        }
    }

    public void removeHandler(@NonNull LogHandler handler) {
        if (handler == null) {
            EMERGENCY_LOGGER.logNPE("handler");
        } else {
            this.handlers.remove(handler);
        }
    }

    @NonNull
    public LoggerImpl getLogger(@NonNull String name) {
        if (name == null) {
            EMERGENCY_LOGGER.logNPE("name");
            return this.loggers.computeIfAbsent(ROOT_LOGGER_NAME, n -> new LoggerImpl((String)n, this.logEventFactory, this));
        }
        return this.loggers.computeIfAbsent(name.trim(), n -> new LoggerImpl((String)n, this.logEventFactory, this));
    }

    @Override
    public boolean isEnabled(@NonNull String name, @NonNull Level level, @Nullable Marker marker) {
        if (name == null) {
            EMERGENCY_LOGGER.logNPE("name");
            return this.isEnabled(ROOT_LOGGER_NAME, level, marker);
        }
        if (level == null) {
            EMERGENCY_LOGGER.logNPE("level");
            return true;
        }
        if (this.handlers.isEmpty()) {
            return this.levelConfig.isEnabled(name, level, marker);
        }
        for (LogHandler handler : this.handlers) {
            if (!handler.isEnabled(name, level, marker)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void accept(@NonNull LogEvent event) {
        if (event == null) {
            EMERGENCY_LOGGER.logNPE("event");
        } else if (this.isEnabled(event.loggerName(), event.level(), event.marker())) {
            try {
                ArrayList<Consumer<LogEvent>> eventConsumers = new ArrayList<Consumer<LogEvent>>();
                this.handlers.stream().filter(handler -> handler.isEnabled(event.loggerName(), event.level(), event.marker())).forEach(eventConsumers::add);
                if (eventConsumers.isEmpty() && this.isEnabled(event.loggerName(), event.level(), event.marker())) {
                    eventConsumers.add(e -> EMERGENCY_LOGGER.log(event));
                }
                if (!eventConsumers.isEmpty()) {
                    eventConsumers.forEach(consumer -> {
                        try {
                            consumer.accept(event);
                        }
                        catch (Throwable throwable) {
                            EMERGENCY_LOGGER.log(Level.ERROR, "Exception in handling log event by consumer", throwable);
                        }
                    });
                }
            }
            catch (Throwable throwable) {
                EMERGENCY_LOGGER.log(Level.ERROR, "Exception in handling log event", throwable);
            }
        }
    }

    public void stopAndFinalize() {
        this.handlers.forEach(LogHandler::stopAndFinalize);
    }

    public LogEventFactory getLogEventFactory() {
        return this.logEventFactory;
    }
}

