/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.logging.api.internal.emergency;

import com.swirlds.logging.api.Level;
import com.swirlds.logging.api.extensions.emergency.EmergencyLogger;
import com.swirlds.logging.api.extensions.event.LogEvent;
import com.swirlds.logging.api.extensions.event.LogEventFactory;
import com.swirlds.logging.api.internal.event.SimpleLogEventFactory;
import com.swirlds.logging.api.internal.format.LineBasedFormat;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.PrintStream;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;

public class EmergencyLoggerImpl
implements EmergencyLogger {
    private static final String EMERGENCY_LOGGER_NAME = "EMERGENCY-LOGGER";
    private static final String UNDEFINED_MESSAGE = "UNDEFINED-MESSAGE";
    private static final int LOG_EVENT_QUEUE_SIZE = 1000;
    private static final String LEVEL_PROPERTY_NAME = "com.swirlds.logging.emergency.level";
    private static final EmergencyLoggerImpl INSTANCE = new EmergencyLoggerImpl();
    public static final Level DEFAULT_LEVEL = Level.DEBUG;
    private final AtomicReference<Level> supportedLevel;
    private final ArrayBlockingQueue<LogEvent> logEvents = new ArrayBlockingQueue(1000);
    private final Lock logEventsAddLock;
    private final ThreadLocal<Boolean> recursionGuard = new ThreadLocal();
    private final LogEventFactory logEventFactory;
    private final Lock handleLock;

    private EmergencyLoggerImpl() {
        this.supportedLevel = new AtomicReference();
        this.logEventsAddLock = new ReentrantLock();
        this.logEventFactory = new SimpleLogEventFactory();
        this.handleLock = new ReentrantLock();
    }

    @NonNull
    private static Level getSupportedLevelFromSystemProperties() {
        String property = System.getProperty(LEVEL_PROPERTY_NAME);
        if (property == null) {
            return DEFAULT_LEVEL;
        }
        if (Objects.equals(property.toUpperCase(), Level.TRACE.name())) {
            return Level.TRACE;
        }
        if (Objects.equals(property.toUpperCase(), Level.DEBUG.name())) {
            return Level.DEBUG;
        }
        if (Objects.equals(property.toUpperCase(), Level.INFO.name())) {
            return Level.INFO;
        }
        if (Objects.equals(property.toUpperCase(), Level.WARN.name())) {
            return Level.WARN;
        }
        if (Objects.equals(property.toUpperCase(), Level.ERROR.name())) {
            return Level.ERROR;
        }
        return Level.TRACE;
    }

    @Override
    public void logNPE(@NonNull String nameOfNullParam) {
        this.log(Level.ERROR, "Null parameter: " + nameOfNullParam, new NullPointerException("Null parameter: " + nameOfNullParam));
    }

    @Override
    public void log(@NonNull Level level, @NonNull String message, @Nullable Throwable thrown) {
        this.log(this.logEventFactory.createLogEvent(level, EMERGENCY_LOGGER_NAME, message, thrown));
    }

    @Override
    public void log(@NonNull LogEvent event) {
        if (event == null) {
            this.logNPE("event");
            return;
        }
        if (this.isLoggable(event.level())) {
            this.callGuarded(event, () -> this.handle(event));
        }
    }

    private boolean isLoggable(@NonNull Level level) {
        Level internalSupportedLevel;
        if (level == null) {
            this.logNPE("level");
            return true;
        }
        if (this.supportedLevel.get() == null) {
            this.supportedLevel.set(EmergencyLoggerImpl.getSupportedLevelFromSystemProperties());
        }
        if ((internalSupportedLevel = this.supportedLevel.get()) == null) {
            return true;
        }
        return internalSupportedLevel.enabledLoggingOfLevel(level);
    }

    private void callGuarded(@NonNull LogEvent fallbackLogEvent, @NonNull Runnable task) {
        this.callGuarded(fallbackLogEvent, null, () -> {
            task.run();
            return null;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private <T> T callGuarded(@Nullable LogEvent fallbackLogEvent, @Nullable T fallbackValue, @NonNull Supplier<T> supplier) {
        Boolean guard = this.recursionGuard.get();
        if (guard != null && guard.booleanValue()) {
            LogEvent logEvent = this.logEventFactory.createLogEvent(Level.ERROR, EMERGENCY_LOGGER_NAME, "Recursion in Emergency logger", new IllegalStateException("Recursion in Emergency logger"));
            this.handle(logEvent);
            if (fallbackLogEvent != null) {
                this.handle(fallbackLogEvent);
            }
            return fallbackValue;
        }
        this.recursionGuard.set(true);
        try {
            T logEvent = supplier.get();
            return logEvent;
        }
        catch (Throwable t) {
            LogEvent logEvent = this.logEventFactory.createLogEvent(Level.ERROR, EMERGENCY_LOGGER_NAME, "Error in Emergency logger", t);
            this.handle(logEvent);
            if (fallbackLogEvent != null) {
                this.handle(fallbackLogEvent);
            }
            T t2 = fallbackValue;
            return t2;
        }
        finally {
            this.recursionGuard.set(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handle(@NonNull LogEvent logEvent) {
        if (logEvent == null) {
            this.logNPE("logEvent");
            return;
        }
        PrintStream printStream = Optional.ofNullable(System.err).orElse(System.out);
        if (printStream != null) {
            this.handleLock.lock();
            try {
                LineBasedFormat.print(printStream, logEvent);
            }
            finally {
                this.handleLock.unlock();
            }
            printStream.flush();
        }
        this.logEventsAddLock.lock();
        try {
            if (this.logEvents.remainingCapacity() == 0) {
                while (this.logEvents.remainingCapacity() <= 100) {
                    this.logEvents.remove();
                }
            }
            this.logEvents.add(logEvent);
        }
        finally {
            this.logEventsAddLock.unlock();
        }
    }

    @NonNull
    public List<LogEvent> publishLoggedEvents() {
        List<LogEvent> result = List.copyOf(this.logEvents);
        this.logEvents.clear();
        return result;
    }

    @NonNull
    public static EmergencyLoggerImpl getInstance() {
        return INSTANCE;
    }
}

