/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.logging.api.internal.event;

import com.swirlds.logging.api.Level;
import com.swirlds.logging.api.Marker;
import com.swirlds.logging.api.extensions.event.LogEvent;
import com.swirlds.logging.api.extensions.event.LogMessage;
import com.swirlds.logging.api.internal.event.SimpleLogMessage;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Collections;
import java.util.Map;

public class MutableLogEvent
implements LogEvent {
    private static final Level INITIAL_LEVEL = Level.TRACE;
    private static final String INITIAL_LOGGER_NAME = "";
    private static final String INITIAL_THREAD_NAME = "";
    private static final long INITIAL_INSTANT = System.currentTimeMillis();
    private static final LogMessage INITIAL_MESSAGE = new SimpleLogMessage("UNDEFINED");
    private static final Throwable INITIAL_THROWABLE = null;
    private static final Marker INITIAL_MARKER = null;
    private static final Map<String, String> INITIAL_CONTEXT = Map.of();
    private Level level;
    private String loggerName;
    private String threadName;
    private long timestamp;
    private LogMessage message;
    private Throwable throwable;
    private Marker marker;
    private Map<String, String> context;

    public MutableLogEvent() {
        this.update(INITIAL_LEVEL, "", "", INITIAL_INSTANT, INITIAL_MESSAGE, INITIAL_THROWABLE, INITIAL_MARKER, INITIAL_CONTEXT);
    }

    public void update(@NonNull Level level, @NonNull String loggerName, @NonNull String threadName, @NonNull long timestamp, @NonNull LogMessage message, @Nullable Throwable throwable, @Nullable Marker marker, @NonNull Map<String, String> context) {
        this.level = level;
        this.loggerName = loggerName;
        this.threadName = threadName;
        this.timestamp = timestamp;
        this.message = message;
        this.throwable = throwable;
        this.marker = marker;
        this.context = Collections.unmodifiableMap(context);
    }

    @Override
    @NonNull
    public Level level() {
        return this.level;
    }

    @Override
    @NonNull
    public String loggerName() {
        return this.loggerName;
    }

    @Override
    @NonNull
    public String threadName() {
        return this.threadName;
    }

    @Override
    @NonNull
    public long timestamp() {
        return this.timestamp;
    }

    @Override
    @NonNull
    public LogMessage message() {
        return this.message;
    }

    @Override
    @Nullable
    public Throwable throwable() {
        return this.throwable;
    }

    @Override
    @Nullable
    public Marker marker() {
        return this.marker;
    }

    @Override
    @NonNull
    public Map<String, String> context() {
        return this.context;
    }
}

