/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.logging.api.internal.event;

import com.swirlds.logging.api.extensions.event.LogMessage;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;

public record ParameterizedLogMessage(@Nullable String messagePattern, @Nullable Object[] args) implements LogMessage
{
    static final char DELIM_START = '{';
    static final String DELIM_STR = "{}";
    private static final char ESCAPE_CHAR = '\\';

    @Override
    @NonNull
    public String getMessage() {
        if (this.messagePattern == null) {
            return "";
        }
        if (this.args == null) {
            return this.messagePattern;
        }
        int i = 0;
        StringBuilder sbuf = new StringBuilder(this.messagePattern.length() + 50);
        for (int L = 0; L < this.args.length; ++L) {
            int j = this.messagePattern.indexOf(DELIM_STR, i);
            if (j == -1) {
                if (i == 0) {
                    return this.messagePattern;
                }
                sbuf.append(this.messagePattern, i, this.messagePattern.length());
                return sbuf.toString();
            }
            if (ParameterizedLogMessage.isEscapedDelimiter(this.messagePattern, j)) {
                if (!ParameterizedLogMessage.isDoubleEscaped(this.messagePattern, j)) {
                    --L;
                    sbuf.append(this.messagePattern, i, j - 1);
                    sbuf.append('{');
                    i = j + 1;
                    continue;
                }
                sbuf.append(this.messagePattern, i, j - 1);
                ParameterizedLogMessage.deeplyAppendParameter(sbuf, this.args[L]);
                i = j + 2;
                continue;
            }
            sbuf.append(this.messagePattern, i, j);
            ParameterizedLogMessage.deeplyAppendParameter(sbuf, this.args[L]);
            i = j + 2;
        }
        sbuf.append(this.messagePattern, i, this.messagePattern.length());
        return sbuf.toString();
    }

    private static boolean isEscapedDelimiter(@NonNull String messagePattern, int delimiterStartIndex) {
        if (delimiterStartIndex == 0) {
            return false;
        }
        char potentialEscape = messagePattern.charAt(delimiterStartIndex - 1);
        return potentialEscape == '\\';
    }

    private static boolean isDoubleEscaped(@NonNull String messagePattern, int delimiterStartIndex) {
        return delimiterStartIndex >= 2 && messagePattern.charAt(delimiterStartIndex - 2) == '\\';
    }

    private static void deeplyAppendParameter(@NonNull StringBuilder sbuf, @Nullable Object o) {
        if (o == null) {
            sbuf.append("null");
            return;
        }
        try {
            String oAsString = o.toString();
            sbuf.append(oAsString);
        }
        catch (Throwable t) {
            sbuf.append("[FAILED toString()]");
        }
    }
}

