/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.logging.api.internal.format;

import com.swirlds.logging.api.Level;
import com.swirlds.logging.api.Marker;
import com.swirlds.logging.api.extensions.emergency.EmergencyLogger;
import com.swirlds.logging.api.extensions.emergency.EmergencyLoggerProvider;
import com.swirlds.logging.api.extensions.event.LogEvent;
import com.swirlds.logging.api.extensions.event.LogMessage;
import com.swirlds.logging.api.internal.format.StackTracePrinter;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Map;

public class LineBasedFormat {
    private static final EmergencyLogger EMERGENCY_LOGGER = EmergencyLoggerProvider.getEmergencyLogger();
    private static final DateTimeFormatter FORMATTER = DateTimeFormatter.ISO_LOCAL_DATE_TIME.withZone(ZoneId.systemDefault());

    public static void print(@NonNull Appendable writer, @NonNull LogEvent event) {
        if (writer == null) {
            EMERGENCY_LOGGER.logNPE("printer");
            return;
        }
        if (event == null) {
            EMERGENCY_LOGGER.logNPE("event");
            return;
        }
        try {
            Map<String, String> context;
            writer.append(LineBasedFormat.timestampAsString(event.timestamp()));
            writer.append(' ');
            writer.append(LineBasedFormat.asString(event.level()));
            writer.append(' ');
            writer.append('[');
            writer.append(LineBasedFormat.asString(event.threadName(), "THREAD"));
            writer.append(']');
            writer.append(' ');
            writer.append(LineBasedFormat.asString(event.loggerName(), "LOGGER"));
            writer.append(" - ");
            writer.append(LineBasedFormat.asString(event.message()));
            Marker marker = event.marker();
            if (marker != null) {
                writer.append(" - [M:");
                writer.append(LineBasedFormat.asString(marker));
                writer.append("]");
            }
            if ((context = event.context()) != null && !context.isEmpty()) {
                writer.append(" - C:");
                writer.append(context.toString());
            }
            writer.append(System.lineSeparator());
            Throwable throwable = event.throwable();
            if (throwable != null) {
                StackTracePrinter.print(writer, throwable);
            }
        }
        catch (Throwable e) {
            EMERGENCY_LOGGER.log(Level.ERROR, "Failed to format and print event", e);
        }
    }

    private static String asString(String str, String suffix) {
        if (str == null) {
            return "UNDEFINED-" + suffix;
        }
        return str;
    }

    private static String asString(Level level) {
        if (level == null) {
            return "UNDEFINED";
        }
        return "%-5s".formatted(level.name());
    }

    private static String asString(LogMessage message) {
        if (message == null) {
            return "UNDEFINED-MESSAGE";
        }
        try {
            return message.getMessage();
        }
        catch (Throwable e) {
            EMERGENCY_LOGGER.log(Level.ERROR, "Failed to format message", e);
            return "BROKEN-MESSAGE";
        }
    }

    private static String timestampAsString(long timestamp) {
        try {
            return "%-26s".formatted(FORMATTER.format(Instant.ofEpochMilli(timestamp)));
        }
        catch (Throwable e) {
            EMERGENCY_LOGGER.log(Level.ERROR, "Failed to format instant", e);
            return "BROKEN-TIMESTAMP          ";
        }
    }

    private static String asString(@Nullable Marker marker) {
        if (marker == null) {
            return "null";
        }
        return String.join((CharSequence)", ", marker.getAllMarkerNames());
    }
}

