/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.logging.api.internal.level;

import com.swirlds.logging.api.Level;
import com.swirlds.logging.api.extensions.emergency.EmergencyLogger;
import com.swirlds.logging.api.extensions.emergency.EmergencyLoggerProvider;
import edu.umd.cs.findbugs.annotations.NonNull;

public enum ConfigLevel {
    UNDEFINED,
    OFF,
    ERROR,
    WARN,
    INFO,
    DEBUG,
    TRACE;


    public boolean enabledLoggingOfLevel(@NonNull Level level) {
        EmergencyLogger emergencyLogger = EmergencyLoggerProvider.getEmergencyLogger();
        if (level == null) {
            emergencyLogger.logNPE("level");
            return true;
        }
        if (this == UNDEFINED) {
            emergencyLogger.log(Level.ERROR, "Undefined logging level!");
            return false;
        }
        if (this == OFF) {
            return false;
        }
        if (this == ERROR) {
            return Level.ERROR.enabledLoggingOfLevel(level);
        }
        if (this == WARN) {
            return Level.WARN.enabledLoggingOfLevel(level);
        }
        if (this == INFO) {
            return Level.INFO.enabledLoggingOfLevel(level);
        }
        if (this == DEBUG) {
            return Level.DEBUG.enabledLoggingOfLevel(level);
        }
        return true;
    }
}

