/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.logging.api.internal.level;

import com.swirlds.config.api.Configuration;
import com.swirlds.logging.api.Level;
import com.swirlds.logging.api.Marker;
import com.swirlds.logging.api.extensions.emergency.EmergencyLogger;
import com.swirlds.logging.api.extensions.emergency.EmergencyLoggerProvider;
import com.swirlds.logging.api.internal.level.ConfigLevel;
import com.swirlds.logging.api.internal.level.MarkerState;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;

public class HandlerLoggingLevelConfig {
    private static final String PROPERTY_LOGGING_LEVEL = "logging.level";
    private static final String PROPERTY_LOGGING_HANDLER_LEVEL = "logging.handler.%s.level";
    private static final String PROPERTY_PACKAGE_LEVEL = "%s.";
    private static final String PROPERTY_LOGGING_MARKER = "logging.marker";
    private static final String PROPERTY_LOGGING_HANDLER_MARKER = "logging.handler.%s.marker";
    private static final String PROPERTY_LOGGING_HANDLER_INHERIT_LEVELS = "logging.handler.%s.inheritLevels";
    private static final ConfigLevel DEFAULT_LEVEL = ConfigLevel.INFO;
    private static final EmergencyLogger EMERGENCY_LOGGER = EmergencyLoggerProvider.getEmergencyLogger();
    private final Map<String, ConfigLevel> levelCache;
    private final AtomicReference<Map<String, MarkerState>> markerConfigCache;
    private final AtomicReference<Map<String, ConfigLevel>> levelConfigProperties;
    private final String name;

    public HandlerLoggingLevelConfig(@NonNull Configuration configuration, @Nullable String name) {
        this.name = name;
        this.levelCache = new ConcurrentHashMap<String, ConfigLevel>();
        this.markerConfigCache = new AtomicReference(new ConcurrentHashMap());
        this.levelConfigProperties = new AtomicReference(new ConcurrentHashMap());
        this.update(configuration);
    }

    public HandlerLoggingLevelConfig(@NonNull Configuration configuration) {
        this(configuration, null);
    }

    public void update(@NonNull Configuration configuration) {
        Objects.requireNonNull(configuration, "configuration must not be null");
        ConfigLevel defaultLevel = (ConfigLevel)((Object)configuration.getValue(PROPERTY_LOGGING_LEVEL, ConfigLevel.class, (Object)ConfigLevel.UNDEFINED));
        String propertyHandler = PROPERTY_LOGGING_HANDLER_LEVEL.formatted(this.name);
        Boolean inheritLevels = (Boolean)configuration.getValue(PROPERTY_LOGGING_HANDLER_INHERIT_LEVELS.formatted(this.name), Boolean.class, (Object)Boolean.TRUE);
        ConcurrentHashMap<String, ConfigLevel> levelConfigProperties = new ConcurrentHashMap<String, ConfigLevel>();
        ConcurrentHashMap<String, MarkerState> markerConfigStore = new ConcurrentHashMap<String, MarkerState>();
        ConfigLevel defaultHandlerLevel = this.name != null ? (ConfigLevel)((Object)configuration.getValue(propertyHandler, ConfigLevel.class, (Object)ConfigLevel.UNDEFINED)) : ConfigLevel.UNDEFINED;
        if (defaultLevel == ConfigLevel.UNDEFINED && defaultHandlerLevel == ConfigLevel.UNDEFINED) {
            levelConfigProperties.put("", DEFAULT_LEVEL);
        } else if (defaultHandlerLevel != ConfigLevel.UNDEFINED) {
            levelConfigProperties.put("", defaultHandlerLevel);
        } else if (Boolean.TRUE.equals(inheritLevels)) {
            levelConfigProperties.put("", defaultLevel);
        } else {
            levelConfigProperties.put("", DEFAULT_LEVEL);
        }
        if (Boolean.TRUE.equals(inheritLevels)) {
            levelConfigProperties.putAll(this.readLevels(PROPERTY_LOGGING_LEVEL, configuration));
            markerConfigStore.putAll(this.readMarkers(PROPERTY_LOGGING_MARKER, configuration));
        }
        this.levelCache.clear();
        if (this.name != null) {
            levelConfigProperties.putAll(this.readLevels(propertyHandler, configuration));
            markerConfigStore.putAll(this.readMarkers(PROPERTY_LOGGING_HANDLER_MARKER.formatted(this.name), configuration));
        }
        this.levelConfigProperties.set(Collections.unmodifiableMap(levelConfigProperties));
        this.markerConfigCache.set(markerConfigStore);
    }

    @NonNull
    private Map<String, MarkerState> readMarkers(@NonNull String prefix, @NonNull Configuration configuration) {
        HashMap<String, MarkerState> result = new HashMap<String, MarkerState>();
        String fullPrefix = PROPERTY_PACKAGE_LEVEL.formatted(prefix);
        configuration.getPropertyNames().filter(n -> n.startsWith(fullPrefix)).forEach(configPropertyName -> {
            String name = configPropertyName.substring(fullPrefix.length());
            MarkerState markerState = (MarkerState)((Object)((Object)configuration.getValue(configPropertyName, MarkerState.class, (Object)MarkerState.UNDEFINED)));
            result.put(name, markerState);
        });
        return result;
    }

    @NonNull
    private Map<String, ConfigLevel> readLevels(@NonNull String prefix, @NonNull Configuration configuration) {
        HashMap result = new HashMap();
        String fullPrefix = PROPERTY_PACKAGE_LEVEL.formatted(prefix);
        configuration.getPropertyNames().filter(n -> n.startsWith(fullPrefix)).forEach(configPropertyName -> {
            String name = configPropertyName.substring(fullPrefix.length());
            ConfigLevel level = (ConfigLevel)((Object)((Object)configuration.getValue(configPropertyName, ConfigLevel.class, (Object)ConfigLevel.UNDEFINED)));
            if (level != ConfigLevel.UNDEFINED) {
                if (this.containsUpperCase(name)) {
                    result.put(name, level);
                } else {
                    result.put(PROPERTY_PACKAGE_LEVEL.formatted(name), level);
                }
            }
        });
        return Collections.unmodifiableMap(result);
    }

    private boolean containsUpperCase(@NonNull String name) {
        return name.chars().anyMatch(Character::isUpperCase);
    }

    public boolean isEnabled(@NonNull String handler, @NonNull Level level, @Nullable Marker marker) {
        List<String> allMarkerNames;
        List<MarkerState> markerStates;
        if (level == null) {
            EMERGENCY_LOGGER.logNPE("level");
            return true;
        }
        if (handler == null) {
            EMERGENCY_LOGGER.logNPE("handler");
            return true;
        }
        if (marker != null && !(markerStates = (allMarkerNames = marker.getAllMarkerNames()).stream().map(markerName -> this.markerConfigCache.get().computeIfAbsent((String)markerName, n -> MarkerState.UNDEFINED)).filter(markerState -> markerState != MarkerState.UNDEFINED).toList()).isEmpty()) {
            if (markerStates.stream().anyMatch(markerState -> markerState == MarkerState.ENABLED)) {
                return true;
            }
            if (markerStates.stream().allMatch(markerState -> markerState == MarkerState.DISABLED)) {
                return false;
            }
        }
        ConfigLevel enabledLevel = this.levelCache.computeIfAbsent(handler.trim(), this::getConfiguredLevel);
        return enabledLevel.enabledLoggingOfLevel(level);
    }

    @NonNull
    private ConfigLevel getConfiguredLevel(@NonNull String name) {
        String stripName = name.strip();
        Map<String, ConfigLevel> stringConfigLevelMap = this.levelConfigProperties.get();
        return stringConfigLevelMap.keySet().stream().filter(stripName::startsWith).reduce((a, b) -> {
            if (a.length() > b.length()) {
                return a;
            }
            return b;
        }).map(stringConfigLevelMap::get).orElseThrow();
    }
}

