/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.merkle.map;

import com.swirlds.common.crypto.Hash;
import com.swirlds.common.merkle.Archivable;
import com.swirlds.common.merkle.MerkleInternal;
import com.swirlds.common.merkle.MerkleNode;
import com.swirlds.common.merkle.copy.MerklePathReplacement;
import com.swirlds.common.merkle.exceptions.ArchivedException;
import com.swirlds.common.merkle.iterators.MerkleIterator;
import com.swirlds.common.merkle.route.MerkleRoute;
import com.swirlds.common.merkle.utility.AbstractBinaryMerkleInternal;
import com.swirlds.common.merkle.utility.DebugIterationEndpoint;
import com.swirlds.common.merkle.utility.Keyed;
import com.swirlds.common.merkle.utility.MerkleUtils;
import com.swirlds.fchashmap.FCHashMap;
import com.swirlds.fchashmap.FCHashMapSettingsFactory;
import com.swirlds.logging.LogMarker;
import com.swirlds.merkle.map.MerkleMapStatistics;
import com.swirlds.merkle.tree.MerkleBinaryTree;
import com.swirlds.merkle.tree.MerkleTreeInternalNode;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.StampedLock;
import org.apache.commons.lang3.time.StopWatch;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;

@DebugIterationEndpoint
public class MerkleMap<K, V extends MerkleNode & Keyed<K>>
extends AbstractBinaryMerkleInternal
implements Archivable,
Map<K, V> {
    public static final long CLASS_ID = -7776220400278906634L;
    private static final Logger LOG = LogManager.getLogger(MerkleMap.class);
    private static final int DEFAULT_INITIAL_MAP_CAPACITY = 2000000;
    protected FCHashMap<K, V> index;
    private final StampedLock lock;
    private boolean archived;
    private static final boolean LOCKS_DISABLED_FOR_DEBUGGING = false;

    private long readLock() {
        return this.lock.readLock();
    }

    private void releaseReadLock(long stamp) {
        this.lock.unlockRead(stamp);
    }

    private long writeLock() {
        return this.lock.writeLock();
    }

    private void releaseWriteLock(long stamp) {
        this.lock.unlockWrite(stamp);
    }

    public boolean childHasExpectedType(int index, long childClassId, int version) {
        if (index == 0) {
            return childClassId == -8881449756281471252L;
        }
        return true;
    }

    protected MerkleBinaryTree<V> getTree() {
        return (MerkleBinaryTree)this.getChild(0);
    }

    private void setTree(MerkleBinaryTree<V> tree) {
        this.setChild(0, (MerkleNode)tree);
    }

    public MerkleMap() {
        this(2000000);
    }

    public MerkleMap(int initialCapacity) {
        this.index = new FCHashMap(initialCapacity);
        this.setTree(new MerkleBinaryTree());
        this.setImmutable(false);
        this.lock = new StampedLock();
    }

    protected MerkleMap(MerkleMap<K, V> that) {
        super(that);
        this.setTree((MerkleBinaryTree<V>)that.getTree().copy());
        this.index = that.index.copy();
        this.lock = new StampedLock();
        this.setImmutable(false);
        that.setImmutable(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getSize() {
        long stamp = this.readLock();
        try {
            long l = this.getTree().size();
            return l;
        }
        finally {
            this.releaseReadLock(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MerkleMap<K, V> copy() {
        this.throwIfImmutable();
        this.throwIfReleased();
        long stamp = this.readLock();
        try {
            MerkleMap<K, V> merkleMap = new MerkleMap<K, V>(this);
            return merkleMap;
        }
        finally {
            this.releaseReadLock(stamp);
        }
    }

    private void updateCache(V entry) {
        this.index.put(((Keyed)entry).getKey(), entry);
    }

    protected synchronized void onRelease() {
        if (!this.isArchived()) {
            this.index.release();
        }
    }

    public synchronized void archive() {
        if (!this.isImmutable()) {
            throw new ArchivedException("can not archive the mutable copy of a map");
        }
        if (FCHashMapSettingsFactory.get().isArchiveEnabled()) {
            long stamp = this.writeLock();
            this.throwIfArchived();
            this.archived = true;
            try {
                if (!this.isImmutable()) {
                    throw new ArchivedException("A mutable FCMap may not have fast read access revoked.");
                }
                this.index.release();
                this.index = null;
            }
            finally {
                this.releaseWriteLock(stamp);
            }
        }
    }

    public boolean isArchived() {
        return this.archived;
    }

    public void throwIfArchived() {
        super.throwIfArchived();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V remove(Object key) {
        this.throwIfImmutable();
        long stamp = this.writeLock();
        try {
            MerkleNode entry = (MerkleNode)this.index.remove(key);
            if (entry == null) {
                V v = null;
                return v;
            }
            this.getTree().delete(entry, x$0 -> this.updateCache((MerkleNode)x$0));
            this.invalidateHash();
            MerkleNode merkleNode = entry;
            return (V)merkleNode;
        }
        finally {
            this.releaseWriteLock(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get(Object key) {
        this.throwIfArchived();
        StopWatch watch = null;
        if (MerkleMapStatistics.isRegistered()) {
            watch = new StopWatch();
            watch.start();
        }
        long stamp = this.readLock();
        try {
            MerkleNode entry = this.index.isReleased() ? this.getTree().findValue(v -> Objects.equals(key, ((Keyed)v).getKey())) : (MerkleNode)this.index.get(key);
            MerkleNode merkleNode = entry;
            return (V)merkleNode;
        }
        finally {
            this.releaseReadLock(stamp);
            if (watch != null) {
                watch.stop();
                MerkleMapStatistics.mmmGetMicroSec.recordValue((double)watch.getTime(TimeUnit.MICROSECONDS));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V getForModify(K key) {
        this.throwIfImmutable();
        StopWatch watch = null;
        if (MerkleMapStatistics.isRegistered()) {
            watch = new StopWatch();
            watch.start();
        }
        long stamp = this.readLock();
        try {
            FCHashMap.ModifiableValue value = this.index.getForModify(key);
            if (value == null) {
                V v = null;
                return v;
            }
            MerkleNode copy = (MerkleNode)value.value();
            MerkleNode original = (MerkleNode)value.original();
            MerkleRoute route = original.getRoute();
            if (copy != original) {
                MerkleNode[] path = MerklePathReplacement.replacePath(this.getTree(), (MerkleRoute)route, (int)1);
                MerkleTreeInternalNode parent = (MerkleTreeInternalNode)MerklePathReplacement.getParentInPath((MerkleNode[])path);
                int indexInParent = MerkleUtils.findChildPositionInParent((MerkleInternal)parent, (MerkleNode)original);
                parent.setChild(indexInParent, copy, route, false);
                this.getTree().registerCopy(original, copy);
            }
            MerkleNode merkleNode = copy;
            return (V)merkleNode;
        }
        finally {
            this.releaseReadLock(stamp);
            if (watch != null) {
                watch.stop();
                MerkleMapStatistics.mmGfmMicroSec.recordValue((double)watch.getTime(TimeUnit.MICROSECONDS));
            }
        }
    }

    @Override
    public V put(K key, V value) {
        this.throwIfImmutable();
        if (key == null) {
            throw new NullPointerException("null keys are not supported");
        }
        if (value == null) {
            throw new NullPointerException("null values are not supported");
        }
        StopWatch watch = null;
        if (MerkleMapStatistics.isRegistered()) {
            watch = new StopWatch();
            watch.start();
        }
        V val = this.putInternal(key, value);
        if (watch != null) {
            watch.stop();
            MerkleMapStatistics.mmPutMicroSec.recordValue((double)watch.getTime(TimeUnit.MICROSECONDS));
        }
        return val;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private V putInternal(K key, V value) {
        long stamp = this.writeLock();
        try {
            if (this.index.containsKey(key)) {
                V v = this.replaceInternal(key, value);
                return v;
            }
            if (value.getReferenceCount() != 0) {
                throw new IllegalArgumentException("Value is in another tree, can not insert");
            }
            ((Keyed)value).setKey(key);
            this.getTree().insert(value, x$0 -> this.updateCache((MerkleNode)x$0));
            this.index.put(key, value);
            this.invalidateHash();
            V v = null;
            return v;
        }
        finally {
            this.releaseWriteLock(stamp);
        }
    }

    @Override
    public int size() {
        return (int)this.getSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsKey(Object key) {
        this.throwIfArchived();
        long stamp = this.readLock();
        try {
            boolean bl = this.index.containsKey(key);
            return bl;
        }
        finally {
            this.releaseReadLock(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty() {
        this.throwIfArchived();
        long stamp = this.readLock();
        try {
            boolean bl = this.getTree().isEmpty();
            return bl;
        }
        finally {
            this.releaseReadLock(stamp);
        }
    }

    private V replaceInternal(K key, V value) {
        MerkleNode oldEntry = (MerkleNode)this.index.get(key);
        if (oldEntry == null) {
            throw new IllegalStateException("Can not replace value that is not in the map");
        }
        if (oldEntry == value) {
            return value;
        }
        if (value.getReferenceCount() != 0) {
            throw new IllegalArgumentException("Value is already in a tree, can not insert into map");
        }
        this.invalidateHash();
        this.getTree().invalidateHash();
        this.getTree().getRoot().invalidateHash();
        ((Keyed)value).setKey(key);
        this.getTree().update(oldEntry, value);
        this.index.put(key, value);
        return (V)oldEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V replace(K key, V value) {
        this.throwIfImmutable();
        if (key == null) {
            throw new NullPointerException("null keys are not supported");
        }
        if (value == null) {
            throw new NullPointerException("null values are not supported");
        }
        StopWatch watch = null;
        if (MerkleMapStatistics.isRegistered()) {
            watch = new StopWatch();
            watch.start();
        }
        long stamp = this.writeLock();
        try {
            V v = this.replaceInternal(key, value);
            return v;
        }
        finally {
            this.releaseWriteLock(stamp);
            if (watch != null) {
                watch.stop();
                MerkleMapStatistics.mmReplaceMicroSec.recordValue((double)watch.getTime(TimeUnit.MICROSECONDS));
            }
        }
    }

    @Override
    public void clear() {
        this.throwIfImmutable();
        long stamp = this.writeLock();
        try {
            this.index.clear();
            this.getTree().clear();
            this.invalidateHash();
        }
        finally {
            this.releaseWriteLock(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<K> keySet() {
        this.throwIfArchived();
        long stamp = this.readLock();
        try {
            MerkleIterator<V> entryIterator = this.getTree().iterator();
            HashSet<Object> keys = new HashSet<Object>();
            while (entryIterator.hasNext()) {
                MerkleNode entry = (MerkleNode)entryIterator.next();
                keys.add(((Keyed)entry).getKey());
            }
            HashSet<Object> hashSet = keys;
            return hashSet;
        }
        finally {
            this.releaseReadLock(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<V> values() {
        this.throwIfArchived();
        long stamp = this.readLock();
        try {
            MerkleIterator<V> entryIterator = this.getTree().iterator();
            HashSet<MerkleNode> values = new HashSet<MerkleNode>();
            while (entryIterator.hasNext()) {
                values.add((MerkleNode)entryIterator.next());
            }
            HashSet<MerkleNode> hashSet = values;
            return hashSet;
        }
        finally {
            this.releaseReadLock(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        this.throwIfArchived();
        long stamp = this.readLock();
        try {
            Set set = this.index.entrySet().stream().collect(HashMap::new, (m, v) -> m.put(v.getKey(), (MerkleNode)v.getValue()), HashMap::putAll).entrySet();
            return set;
        }
        finally {
            this.releaseReadLock(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsValue(Object value) {
        this.throwIfArchived();
        long stamp = this.readLock();
        try {
            boolean bl = this.values().stream().anyMatch(v -> Objects.equals(v, value));
            return bl;
        }
        finally {
            this.releaseReadLock(stamp);
        }
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        for (Map.Entry<K, V> entry : m.entrySet()) {
            this.put(entry.getKey(), (V)((MerkleNode)entry.getValue()));
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MerkleMap)) {
            return false;
        }
        MerkleMap merkleMap = (MerkleMap)o;
        Hash rootHash = this.getRootHash();
        Hash otherRootHash = merkleMap.getRootHash();
        return rootHash.equals((Object)otherRootHash);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int hashCode() {
        long stamp = this.readLock();
        try {
            Hash hash = this.getTree().getHash();
            if (hash == null) {
                int n = super.hashCode();
                return n;
            }
            int n = hash.hashCode();
            return n;
        }
        finally {
            this.releaseReadLock(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hash getRootHash() {
        long stamp = this.readLock();
        try {
            Hash hash = this.getTree().getHash();
            return hash;
        }
        finally {
            this.releaseReadLock(stamp);
        }
    }

    public String toString() {
        return String.format("Size: %d - %s", this.getTree().size(), this.getRootHash());
    }

    protected FCHashMap<K, V> getIndex() {
        return this.index;
    }

    public long getClassId() {
        return -7776220400278906634L;
    }

    public int getVersion() {
        return 1;
    }

    public void initialize() {
        for (MerkleNode nextEntry : this.getTree()) {
            this.index.put(((Keyed)nextEntry).getKey(), (Object)nextEntry);
        }
        Supplier[] supplierArray = new Supplier[2];
        supplierArray[0] = () -> this.index.size();
        supplierArray[1] = () -> this.getTree().size();
        LOG.debug(LogMarker.RECONNECT.getMarker(), "MerkleMap Initialized [ internalMapSize = {}, treeSize = {} ]", supplierArray);
    }

    private static class ChildIndices {
        public static final int TREE = 0;
        public static final int CHILD_COUNT = 1;

        private ChildIndices() {
        }
    }

    private static class ClassVersion {
        public static final int ORIGINAL = 1;

        private ClassVersion() {
        }
    }
}

