/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.merkle.map;

import com.swirlds.common.FastCopyable;
import com.swirlds.common.Releasable;
import com.swirlds.common.io.SelfSerializable;
import com.swirlds.common.io.SerializableDataInputStream;
import com.swirlds.common.io.SerializableDataOutputStream;
import com.swirlds.common.merkle.utility.AbstractMerkleLeaf;
import com.swirlds.common.merkle.utility.Keyed;
import java.io.IOException;
import java.util.Objects;

public class MerkleMapEntryKey<K extends SelfSerializable & FastCopyable>
extends AbstractMerkleLeaf
implements Keyed<K> {
    private static final long CLASS_ID = 1648833955562454264L;
    private K key;

    public MerkleMapEntryKey() {
    }

    public MerkleMapEntryKey(K key) {
        this.key = key;
    }

    private MerkleMapEntryKey(MerkleMapEntryKey<K> that) {
        if (that.getKey() != null) {
            this.key = (SelfSerializable)((FastCopyable)that.getKey()).copy();
        }
        that.setImmutable(true);
    }

    public K getKey() {
        return this.key;
    }

    public void setKey(K key) {
        this.key = key;
    }

    public long getClassId() {
        return 1648833955562454264L;
    }

    public int getVersion() {
        return 1;
    }

    public void serialize(SerializableDataOutputStream out) throws IOException {
        out.writeSerializable(this.key, true);
    }

    public void deserialize(SerializableDataInputStream in, int version) throws IOException {
        this.key = in.readSerializable();
    }

    public MerkleMapEntryKey<K> copy() {
        return new MerkleMapEntryKey<K>(this);
    }

    protected void onRelease() {
        if (this.key != null) {
            ((Releasable)this.key).release();
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MerkleMapEntryKey)) {
            return false;
        }
        MerkleMapEntryKey that = (MerkleMapEntryKey)((Object)o);
        return Objects.equals(this.key, that.key);
    }

    public int hashCode() {
        return Objects.hash(this.key);
    }

    private static final class ClassVersion {
        public static final int ORIGINAL = 1;

        private ClassVersion() {
        }
    }
}

