/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.merkle.map;

import com.swirlds.common.Platform;
import com.swirlds.common.statistics.StatEntry;
import com.swirlds.common.statistics.StatsBuffered;
import com.swirlds.common.statistics.StatsRunningAverage;

public final class MerkleMapStatistics {
    private static volatile boolean registered;
    private static final double DEFAULT_HALF_LIFE = 10.0;
    protected static final StatsRunningAverage mmmGetMicroSec;
    protected static final StatsRunningAverage mmGfmMicroSec;
    protected static final StatsRunningAverage mmReplaceMicroSec;
    protected static final StatsRunningAverage mmPutMicroSec;
    private static final String MM_CATEGORY = "MM";
    private static final String FORMAT_FLOAT_3SIGFIG = "%,11.3f";

    private MerkleMapStatistics() {
    }

    public static boolean isRegistered() {
        return registered;
    }

    public static void register(Platform platform) {
        platform.addAppStatEntry(new StatEntry(MM_CATEGORY, "mmGetMicroSec", "avg time taken to execute the MerkleMap get method (in microseconds)", FORMAT_FLOAT_3SIGFIG, (StatsBuffered)mmmGetMicroSec, h -> {
            mmmGetMicroSec.reset(h.doubleValue());
            return mmmGetMicroSec;
        }, null, () -> ((StatsRunningAverage)mmmGetMicroSec).getWeightedMean()));
        platform.addAppStatEntry(new StatEntry(MM_CATEGORY, "mmGfmMicroSec", "avg time taken to execute the MerkleMap getForModify method (in microseconds)", FORMAT_FLOAT_3SIGFIG, (StatsBuffered)mmGfmMicroSec, h -> {
            mmGfmMicroSec.reset(h.doubleValue());
            return mmGfmMicroSec;
        }, null, () -> ((StatsRunningAverage)mmGfmMicroSec).getWeightedMean()));
        platform.addAppStatEntry(new StatEntry(MM_CATEGORY, "mmReplaceMicroSec", "avg time taken to execute the MerkleMap replace method (in microseconds)", FORMAT_FLOAT_3SIGFIG, (StatsBuffered)mmReplaceMicroSec, h -> {
            mmReplaceMicroSec.reset(h.doubleValue());
            return mmReplaceMicroSec;
        }, null, () -> ((StatsRunningAverage)mmReplaceMicroSec).getWeightedMean()));
        platform.addAppStatEntry(new StatEntry(MM_CATEGORY, "mmPutMicroSec", "avg time taken to execute the MerkleMap put method (in microseconds)", FORMAT_FLOAT_3SIGFIG, (StatsBuffered)mmPutMicroSec, h -> {
            mmPutMicroSec.reset(h.doubleValue());
            return mmPutMicroSec;
        }, null, () -> ((StatsRunningAverage)mmPutMicroSec).getWeightedMean()));
        registered = true;
    }

    static {
        mmmGetMicroSec = new StatsRunningAverage(10.0);
        mmGfmMicroSec = new StatsRunningAverage(10.0);
        mmReplaceMicroSec = new StatsRunningAverage(10.0);
        mmPutMicroSec = new StatsRunningAverage(10.0);
    }
}

