/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.virtualmap;

import com.swirlds.virtualmap.VirtualMapSettings;
import java.time.Duration;

public final class DefaultVirtualMapSettings
implements VirtualMapSettings {
    public static final int DEFAULT_NUM_HASH_THREADS = -1;
    public static final double DEFAULT_PERCENT_HASH_THREADS = 50.0;
    public static final int DEFAULT_NUM_CLEANER_THREADS = -1;
    public static final double DEFAULT_PERCENT_CLEANER_THREADS = 25.0;
    public static final long DEFAULT_MAXIMUM_VIRTUAL_MAP_SIZE = Integer.MAX_VALUE;
    public static final long DEFAULT_VIRTUAL_MAP_WARNING_THRESHOLD = 5000000L;
    public static final long DEFAULT_VIRTUAL_MAP_WARNING_INTERVAL = 100000L;
    public static final int DEFAULT_FLUSH_INTERVAL = 20;
    public static final int DEFAULT_PREFERRED_FLUSH_QUEUE_SIZE = 2;
    public static final Duration DEFAULT_FLUSH_THROTTLE_STEP_SIZE = Duration.ofMillis(200L);
    public static final Duration DEFAULT_MAXIMUM_FLUSH_THROTTLE_PERIOD = Duration.ofSeconds(5L);

    @Override
    public double getPercentHashThreads() {
        return 50.0;
    }

    @Override
    public int getNumHashThreads() {
        int threads = Integer.getInteger("hashingThreadCount", (int)((double)Runtime.getRuntime().availableProcessors() * (this.getPercentHashThreads() / 100.0)));
        return Math.max(1, threads);
    }

    @Override
    public double getPercentCleanerThreads() {
        return 25.0;
    }

    @Override
    public int getNumCleanerThreads() {
        int numProcessors = Runtime.getRuntime().availableProcessors();
        int threads = Integer.getInteger("cleanerThreadCount", (int)((double)numProcessors * (this.getPercentCleanerThreads() / 100.0)));
        return Math.max(1, threads);
    }

    @Override
    public long getMaximumVirtualMapSize() {
        return Integer.MAX_VALUE;
    }

    @Override
    public long getVirtualMapWarningThreshold() {
        return 5000000L;
    }

    @Override
    public long getVirtualMapWarningInterval() {
        return 100000L;
    }

    @Override
    public int getFlushInterval() {
        return 20;
    }

    @Override
    public int getPreferredFlushQueueSize() {
        return 2;
    }

    @Override
    public Duration getFlushThrottleStepSize() {
        return DEFAULT_FLUSH_THROTTLE_STEP_SIZE;
    }

    @Override
    public Duration getMaximumFlushThrottlePeriod() {
        return DEFAULT_MAXIMUM_FLUSH_THROTTLE_PERIOD;
    }
}

