/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.virtualmap;

import com.swirlds.common.CommonUtils;
import com.swirlds.common.crypto.Hash;
import com.swirlds.common.io.ExternalSelfSerializable;
import com.swirlds.common.io.SelfSerializable;
import com.swirlds.common.io.SerializableDataInputStream;
import com.swirlds.common.io.SerializableDataOutputStream;
import com.swirlds.common.merkle.MerkleNode;
import com.swirlds.common.merkle.io.SerializationStrategy;
import com.swirlds.common.merkle.utility.AbstractBinaryMerkleInternal;
import com.swirlds.common.statistics.StatEntry;
import com.swirlds.virtualmap.VirtualKey;
import com.swirlds.virtualmap.VirtualValue;
import com.swirlds.virtualmap.datasource.VirtualDataSource;
import com.swirlds.virtualmap.datasource.VirtualDataSourceBuilder;
import com.swirlds.virtualmap.internal.merkle.StateAccessorImpl;
import com.swirlds.virtualmap.internal.merkle.VirtualMapState;
import com.swirlds.virtualmap.internal.merkle.VirtualRootNode;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;

public final class VirtualMap<K extends VirtualKey<? super K>, V extends VirtualValue>
extends AbstractBinaryMerkleInternal
implements ExternalSelfSerializable {
    public static final long CLASS_ID = -5151568835156514733L;
    private static final Set<SerializationStrategy> STRATEGIES = Set.of(SerializationStrategy.EXTERNAL_SELF_SERIALIZATION);
    private VirtualMapState state;
    private VirtualRootNode<K, V> root;

    public VirtualMap() {
    }

    public VirtualMap(String label, VirtualDataSourceBuilder<K, V> dataSourceBuilder) {
        this.setChild(0, (MerkleNode)new VirtualMapState(Objects.requireNonNull(label)));
        this.setChild(1, new VirtualRootNode<K, V>(Objects.requireNonNull(dataSourceBuilder)));
    }

    private VirtualMap(VirtualMap<K, V> source) {
        this.setChild(0, (MerkleNode)source.getState().copy());
        this.setChild(1, (MerkleNode)source.getRoot().copy());
    }

    public VirtualDataSource<K, V> getDataSource() {
        return this.root.getDataSource();
    }

    VirtualMapState getState() {
        return this.state;
    }

    VirtualRootNode<K, V> getRoot() {
        return this.root;
    }

    public void registerStatistics(Consumer<StatEntry> registry) {
        this.root.registerStatistics(registry);
    }

    public long getClassId() {
        return -5151568835156514733L;
    }

    public int getVersion() {
        return 1;
    }

    public VirtualMap<K, V> copy() {
        this.throwIfImmutable();
        this.throwIfReleased();
        VirtualMap<K, V> copy = new VirtualMap<K, V>(this);
        this.setImmutable(true);
        return copy;
    }

    public void setChild(int index, MerkleNode child) {
        if (index == 0) {
            this.state = (VirtualMapState)child.cast();
        } else if (index == 1) {
            this.root = (VirtualRootNode)child.cast();
            this.root.postInit(new StateAccessorImpl(this.state));
        }
        super.setChild(index, child);
    }

    public Set<SerializationStrategy> supportedSerialization(int version) {
        return STRATEGIES;
    }

    public void serializeExternal(SerializableDataOutputStream out, File outputDirectory) throws IOException {
        String outputFileName = this.state.getLabel() + ".vmap";
        byte[] outputFileNameBytes = CommonUtils.getNormalisedStringBytes((String)outputFileName);
        out.writeInt(outputFileNameBytes.length);
        out.writeNormalisedString(outputFileName);
        File outputFile = new File(outputDirectory, outputFileName);
        try (SerializableDataOutputStream serout = new SerializableDataOutputStream((OutputStream)new BufferedOutputStream(new FileOutputStream(outputFile)));){
            serout.writeSerializable((SelfSerializable)this.state, true);
            serout.writeInt(this.root.getVersion());
            this.root.serializeExternal(serout, outputDirectory);
        }
    }

    public void deserializeExternal(SerializableDataInputStream in, File inputDirectory, Hash hash, int version) throws IOException {
        int fileNameLengthInBytes = in.readInt();
        String inputFileName = in.readNormalisedString(fileNameLengthInBytes);
        File inputFile = new File(inputDirectory, inputFileName);
        this.loadFromFile(inputFile);
    }

    public void loadFromFile(File inputFile) throws IOException {
        try (SerializableDataInputStream serin = new SerializableDataInputStream((InputStream)new BufferedInputStream(new FileInputStream(inputFile)));){
            this.state = (VirtualMapState)serin.readSerializable();
            this.root = new VirtualRootNode();
            this.root.deserializeExternal(serin, inputFile.getParentFile(), null, serin.readInt());
            this.addDeserializedChildren(List.of(this.state, this.root), this.getVersion());
        }
    }

    public long size() {
        return this.state.getSize();
    }

    public boolean isEmpty() {
        return this.root.isEmpty();
    }

    public boolean isValid() {
        return this.root != null;
    }

    public boolean containsKey(K key) {
        return this.root.containsKey(key);
    }

    public V getForModify(K key) {
        return this.root.getForModify(key);
    }

    public V get(K key) {
        return this.root.get(key);
    }

    public void put(K key, V value) {
        this.root.put(key, value);
    }

    public V replace(K key, V value) {
        return this.root.replace(key, value);
    }

    public V remove(K key) {
        return this.root.remove(key);
    }

    private static final class ChildIndices {
        private static final int MAP_STATE_CHILD_INDEX = 0;
        private static final int VIRTUAL_ROOT_CHILD_INDEX = 1;

        private ChildIndices() {
        }
    }

    private static class ClassVersion {
        public static final int ORIGINAL = 1;

        private ClassVersion() {
        }
    }
}

