/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.virtualmap.datasource;

import com.swirlds.common.crypto.Hash;
import com.swirlds.common.statistics.StatEntry;
import com.swirlds.virtualmap.VirtualKey;
import com.swirlds.virtualmap.VirtualValue;
import com.swirlds.virtualmap.datasource.VirtualInternalRecord;
import com.swirlds.virtualmap.datasource.VirtualLeafRecord;
import java.io.IOException;
import java.nio.file.Path;
import java.util.function.Consumer;
import java.util.stream.Stream;

public interface VirtualDataSource<K extends VirtualKey<? super K>, V extends VirtualValue> {
    public static final int INVALID_PATH = -1;

    public void close() throws IOException;

    public void saveRecords(long var1, long var3, Stream<VirtualInternalRecord> var5, Stream<VirtualLeafRecord<K, V>> var6, Stream<VirtualLeafRecord<K, V>> var7) throws IOException;

    public VirtualLeafRecord<K, V> loadLeafRecord(K var1) throws IOException;

    public VirtualLeafRecord<K, V> loadLeafRecord(long var1) throws IOException;

    public VirtualInternalRecord loadInternalRecord(long var1) throws IOException;

    public Hash loadLeafHash(long var1) throws IOException;

    public void snapshot(Path var1) throws IOException;

    public void copyStatisticsFrom(VirtualDataSource<K, V> var1);

    public void registerStatistics(Consumer<StatEntry> var1);

    default public void startBackgroundCompaction() {
    }

    default public void stopBackgroundCompaction() {
    }
}

