/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.virtualmap.datasource;

import com.swirlds.common.crypto.Hash;
import com.swirlds.common.io.SelfSerializable;
import com.swirlds.common.io.SerializableDataInputStream;
import com.swirlds.common.io.SerializableDataOutputStream;
import com.swirlds.virtualmap.VirtualKey;
import com.swirlds.virtualmap.VirtualValue;
import com.swirlds.virtualmap.datasource.VirtualRecord;
import java.io.IOException;
import java.util.Objects;

public final class VirtualLeafRecord<K extends VirtualKey, V extends VirtualValue>
extends VirtualRecord
implements SelfSerializable {
    private static final long CLASS_ID = 293002664819372644L;
    private K key;
    private V value;

    public VirtualLeafRecord() {
        super(-1L, null);
    }

    public VirtualLeafRecord(long path, Hash hash, K key, V value) {
        super(path, hash);
        this.key = key;
        this.value = value;
    }

    public K getKey() {
        return this.key;
    }

    public V getValue() {
        return this.value;
    }

    public void setValue(V value) {
        if (this.value != value) {
            this.value = value;
            this.setHash(null);
        }
    }

    public long getClassId() {
        return 293002664819372644L;
    }

    public int getVersion() {
        return 1;
    }

    public void serialize(SerializableDataOutputStream out) throws IOException {
        out.writeLong(this.getPath());
        out.writeSerializable(this.key, true);
        out.writeSerializable(this.value, true);
    }

    public void deserialize(SerializableDataInputStream in, int version) throws IOException {
        this.setPath(in.readLong());
        this.key = (VirtualKey)in.readSerializable();
        this.value = (VirtualValue)in.readSerializable();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        VirtualLeafRecord that = (VirtualLeafRecord)o;
        return Objects.equals(this.key, that.key) && Objects.equals(this.value, that.value);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.key, this.value);
    }

    public String toString() {
        return "VirtualLeafRecord{key=" + this.key + ", value=" + this.value + ", path=" + this.getPath() + ", hash=" + this.getHash() + "}";
    }

    private static final class ClassVersion {
        public static final int ORIGINAL = 1;

        private ClassVersion() {
        }
    }
}

