/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.virtualmap.datasource;

import com.swirlds.common.crypto.Hash;
import com.swirlds.common.crypto.Hashable;
import java.util.Objects;

public abstract class VirtualRecord
implements Hashable {
    private volatile long path;
    private volatile Hash hash;

    protected VirtualRecord(long path, Hash hash) {
        assert (path == -1L || path >= 0L);
        this.path = path;
        this.hash = hash;
    }

    public final void setHash(Hash hash) {
        this.hash = hash;
    }

    public final Hash getHash() {
        return this.hash;
    }

    public final long getPath() {
        return this.path;
    }

    public final void setPath(long path) {
        assert (path >= 0L);
        this.path = path;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof VirtualRecord)) {
            return false;
        }
        VirtualRecord that = (VirtualRecord)o;
        return this.path == that.path && Objects.equals(this.hash, that.hash);
    }

    public int hashCode() {
        return Objects.hash(this.path, this.hash);
    }
}

