/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.virtualmap.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class Path {
    public static final long ROOT_PATH = 0L;
    public static final long FIRST_LEFT_PATH = 1L;
    public static final long INVALID_PATH = -1L;
    public static final int MAX_RANK_VALUE = 62;
    private static final int MAX_NUMBER_OF_LEADING_ZEROS = 64;
    private static final long LEADING_BIT_FOR_INDEX_IN_RANK = 2L;

    private Path() {
    }

    public static int getRank(long path) {
        if (path == 0L) {
            return 0;
        }
        return 63 - Long.numberOfLeadingZeros(path + 1L);
    }

    public static long getIndexInRank(long path) {
        if (path == -1L) {
            return -1L;
        }
        if (path == 0L) {
            return 0L;
        }
        int rank = Path.getRank(path);
        return path - (2L << rank - 1) + 1L;
    }

    public static long getPathForRankAndIndex(int rank, long index) {
        if (rank == -1) {
            return -1L;
        }
        assert (rank >= 0) : "Rank must be strictly non-negative";
        assert (index >= 0L) : "Index must be strictly non-negative";
        if (rank == 0 && index == 0L) {
            return 0L;
        }
        long maxForRank = 1L << rank;
        if (index > maxForRank - 1L) {
            throw new IllegalArgumentException("The index [" + index + "] is too large for the number of items at this rank. maxForRank =" + maxForRank);
        }
        return index + (2L << rank - 1) - 1L;
    }

    public static boolean isLeft(long path) {
        assert (path != -1L);
        return path == 0L || (path & 1L) == 1L;
    }

    public static boolean isFarRight(long path) {
        assert (path != -1L);
        int numLeadingZeros = Long.numberOfLeadingZeros(path);
        return path == 0L || (path ^ 1L | -1L << 64 - numLeadingZeros) == -1L;
    }

    public static long getParentPath(long path) {
        return path - 1L >> 1;
    }

    public static long getChildPath(long parentPath, int childIndex) {
        assert (childIndex == 0 || childIndex == 1) : "Only binary trees are supported";
        return childIndex == 0 ? Path.getLeftChildPath(parentPath) : Path.getRightChildPath(parentPath);
    }

    public static long getLeftChildPath(long path) {
        return (path << 1) + 1L;
    }

    public static long getRightChildPath(long path) {
        return (path << 1) + 2L;
    }

    public static List<Integer> getRouteStepsFromRoot(long targetPath) {
        ArrayList<Integer> routes = new ArrayList<Integer>();
        while (targetPath > 0L) {
            routes.add(Path.isLeft(targetPath) ? 0 : 1);
            targetPath = Path.getParentPath(targetPath);
        }
        Collections.reverse(routes);
        return routes;
    }

    public static long getNextStep(long thisPath, long targetPath) {
        int midPoint;
        assert (thisPath < targetPath);
        assert (thisPath != -1L);
        assert (targetPath != -1L);
        int thisRank = Path.getRank(thisPath);
        int targetRank = Path.getRank(targetPath);
        int relativeRank = targetRank - thisRank;
        long leftMostPath = thisPath << relativeRank | -1L << relativeRank ^ 0xFFFFFFFFFFFFFFFFL;
        return targetPath - leftMostPath < (long)(midPoint = 1 << relativeRank - 1) ? Path.getLeftChildPath(thisPath) : Path.getRightChildPath(thisPath);
    }

    public static long getSiblingPath(long path) {
        if (path == 0L) {
            return -1L;
        }
        return Path.isLeft(path) ? path + 1L : path - 1L;
    }
}

