/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.virtualmap.internal.cache;

import java.util.Arrays;
import java.util.Comparator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.stream.Stream;

final class ConcurrentArray<T> {
    private static final int DEFAULT_ELEMENT_ARRAY_LENGTH = 1024;
    private final ConcurrentLinkedDeque<SubArray<T>> arrays = new ConcurrentLinkedDeque();
    private final AtomicInteger elementCount = new AtomicInteger(0);
    private final AtomicBoolean immutable = new AtomicBoolean(false);
    private final int subarrayCapacity;

    ConcurrentArray() {
        this(1024);
    }

    ConcurrentArray(int capacity) {
        if (capacity <= 0) {
            throw new IllegalArgumentException("The capacity must be > 0");
        }
        this.subarrayCapacity = capacity;
        this.arrays.add(new SubArray(capacity));
    }

    ConcurrentArray(ConcurrentArray<T> arrayOne, ConcurrentArray<T> arrayTwo) {
        Objects.requireNonNull(arrayOne);
        Objects.requireNonNull(arrayTwo);
        if (!arrayOne.isImmutable() || !arrayTwo.isImmutable()) {
            throw new IllegalArgumentException("The source arrays *must* be immutable");
        }
        if (arrayOne == arrayTwo) {
            throw new IllegalArgumentException("Both arguments should be distinct instances");
        }
        this.subarrayCapacity = 1;
        this.arrays.addAll(arrayOne.arrays);
        this.arrays.addAll(arrayTwo.arrays);
        this.elementCount.addAndGet(arrayOne.size() + arrayTwo.size());
        this.immutable.set(true);
    }

    ConcurrentArray<T> seal() {
        this.immutable.set(true);
        return this;
    }

    boolean isImmutable() {
        return this.immutable.get();
    }

    int size() {
        return this.elementCount.get();
    }

    T get(int index) {
        int size = this.size();
        if (index < 0 || index >= size) {
            throw new IndexOutOfBoundsException("index " + index + " is out of bounds (0, " + size + "]");
        }
        int count = 0;
        for (SubArray<T> arr : this.arrays) {
            int arrSize = arr.size.get();
            if (index >= count + arrSize) {
                count += arrSize;
                continue;
            }
            return arr.get(index - count);
        }
        throw new NoSuchElementException("Not able to find an element by that index");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void add(T element) {
        Objects.requireNonNull(element);
        if (this.immutable.get()) {
            throw new IllegalStateException("You can not call add on a immutable ConcurrentArray");
        }
        SubArray<T> lastArray = this.arrays.getLast();
        boolean success = lastArray.add(element);
        if (!success) {
            ConcurrentArray concurrentArray = this;
            synchronized (concurrentArray) {
                lastArray = this.arrays.getLast();
                success = lastArray.add(element);
                if (!success) {
                    SubArray<T> newArray = new SubArray<T>(this.subarrayCapacity);
                    success = newArray.add(element);
                    assert (success);
                    this.arrays.add(newArray);
                }
            }
        }
        this.elementCount.incrementAndGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Stream<T> sortedStream(Comparator<T> comparator) {
        if (!this.immutable.get()) {
            throw new IllegalStateException("You can not call sortedStream on a mutable ConcurrentArray");
        }
        int numberOfElements = this.elementCount.get();
        if (numberOfElements == 0) {
            return Stream.empty();
        }
        ConcurrentArray concurrentArray = this;
        synchronized (concurrentArray) {
            SubArray newArray = new SubArray(numberOfElements);
            int nextIndex = 0;
            for (SubArray<T> array : this.arrays) {
                int arraySize = array.size.get();
                System.arraycopy(array.array, 0, newArray.array, nextIndex, arraySize);
                nextIndex += arraySize;
            }
            newArray.size.set(numberOfElements);
            this.arrays.clear();
            this.arrays.add(newArray);
            Arrays.parallelSort(newArray.array, 0, numberOfElements, comparator);
        }
        return Arrays.stream(this.arrays.getFirst().array, 0, this.size());
    }

    public void parallelTraverse(Executor executor, Consumer<T> action) {
        if (!this.isImmutable()) {
            throw new IllegalArgumentException("You can not call parallelTraverse on a mutable ConcurrentArray");
        }
        for (SubArray<T> subArray : this.arrays) {
            executor.execute(() -> {
                T[] array = subArray.array;
                int size = subArray.size.get();
                for (int i = 0; i < size; ++i) {
                    action.accept(array[i]);
                }
            });
        }
    }

    private static class SubArray<T> {
        private final T[] array;
        private final AtomicInteger size = new AtomicInteger(0);

        public SubArray(int capacity) {
            this.array = new Object[capacity];
        }

        T get(int index) {
            return this.array[index];
        }

        boolean add(T element) {
            int index = this.size.getAndIncrement();
            if (index >= this.array.length) {
                this.size.decrementAndGet();
                return false;
            }
            this.array[index] = element;
            return true;
        }
    }
}

