/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.virtualmap.internal.cache;

import com.swirlds.common.FastCopyable;
import com.swirlds.common.MutabilityException;
import com.swirlds.common.crypto.Hash;
import com.swirlds.common.io.SelfSerializable;
import com.swirlds.common.io.SerializableDataInputStream;
import com.swirlds.common.io.SerializableDataOutputStream;
import com.swirlds.common.threading.ThreadConfiguration;
import com.swirlds.virtualmap.VirtualKey;
import com.swirlds.virtualmap.VirtualMapSettingsFactory;
import com.swirlds.virtualmap.VirtualValue;
import com.swirlds.virtualmap.datasource.VirtualInternalRecord;
import com.swirlds.virtualmap.datasource.VirtualLeafRecord;
import com.swirlds.virtualmap.datasource.VirtualRecord;
import com.swirlds.virtualmap.internal.cache.ConcurrentArray;
import java.io.IOException;
import java.util.Comparator;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BiFunction;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class VirtualNodeCache<K extends VirtualKey<? super K>, V extends VirtualValue>
implements FastCopyable,
SelfSerializable {
    private static final Logger LOG = LogManager.getLogger(VirtualNodeCache.class);
    private static final long CLASS_ID = 5275760189460016428L;
    public static final VirtualLeafRecord<?, ?> DELETED_LEAF_RECORD = new VirtualLeafRecord<Object, Object>(-1L, null, null, null);
    public static final VirtualInternalRecord DELETED_INTERNAL_RECORD = new VirtualInternalRecord(-1L);
    private static final Comparator<Mutation<VirtualLeafRecord<?, ?>>> DIRTY_LEAF_COMPARATOR = new MutationComparator();
    private static final Comparator<Mutation<VirtualLeafRecord<?, ?>>> DELETED_LEAF_COMPARATOR = new DeletedMutationComparator();
    private static final Comparator<Mutation<VirtualInternalRecord>> DIRTY_INTERNAL_COMPARATOR = new MutationComparator<VirtualInternalRecord>();
    private static final int CACHE_CLEANER_THREAD_COUNT = Math.max(1, VirtualMapSettingsFactory.get().getNumCleanerThreads());
    private static final Executor CLEANING_POOL = Boolean.getBoolean("syncCleaningPool") ? Runnable::run : new ThreadPoolExecutor(CACHE_CLEANER_THREAD_COUNT, CACHE_CLEANER_THREAD_COUNT, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadConfiguration().setThreadGroup(new ThreadGroup("virtual-cache-cleaners")).setComponent("virtual-map").setThreadName("cache-cleaner").setExceptionHandler((t, ex) -> LOG.error("Failed to purge unneeded key/mutationList pairs", ex)).buildFactory());
    private final AtomicLong fastCopyVersion = new AtomicLong(0L);
    private final AtomicReference<VirtualNodeCache<K, V>> next = new AtomicReference();
    private final AtomicReference<VirtualNodeCache<K, V>> prev = new AtomicReference();
    private final Map<K, Mutation<VirtualLeafRecord<K, V>>> keyToDirtyLeafIndex;
    private final Map<Long, Mutation<K>> pathToDirtyLeafIndex;
    private final Map<Long, Mutation<VirtualInternalRecord>> pathToDirtyInternalIndex;
    private final AtomicBoolean released = new AtomicBoolean(false);
    private final AtomicBoolean leafIndexesAreImmutable = new AtomicBoolean(false);
    private final AtomicBoolean internalIndexesAreImmutable = new AtomicBoolean(true);
    private volatile ConcurrentArray<Mutation<VirtualLeafRecord<K, V>>> dirtyLeaves = new ConcurrentArray();
    private volatile ConcurrentArray<Mutation<K>> dirtyLeafPaths = new ConcurrentArray();
    private volatile ConcurrentArray<Mutation<VirtualInternalRecord>> dirtyInternals = new ConcurrentArray();
    private final ReentrantLock releaseLock;
    private final AtomicBoolean snapshot = new AtomicBoolean(false);

    public VirtualNodeCache() {
        this.keyToDirtyLeafIndex = new ConcurrentHashMap<K, Mutation<VirtualLeafRecord<K, V>>>();
        this.pathToDirtyLeafIndex = new ConcurrentHashMap<Long, Mutation<K>>();
        this.pathToDirtyInternalIndex = new ConcurrentHashMap<Long, Mutation<VirtualInternalRecord>>();
        this.releaseLock = new ReentrantLock();
    }

    private VirtualNodeCache(VirtualNodeCache<K, V> source) {
        this.fastCopyVersion.set(source.fastCopyVersion.get() + 1L);
        this.keyToDirtyLeafIndex = source.keyToDirtyLeafIndex;
        this.pathToDirtyLeafIndex = source.pathToDirtyLeafIndex;
        this.pathToDirtyInternalIndex = source.pathToDirtyInternalIndex;
        this.releaseLock = source.releaseLock;
        source.prepareForHashing();
        this.next.set(source);
        source.prev.set(this);
    }

    public VirtualNodeCache<K, V> copy() {
        return new VirtualNodeCache<K, V>(this);
    }

    public void prepareForHashing() {
        this.leafIndexesAreImmutable.set(true);
        this.internalIndexesAreImmutable.set(false);
        this.dirtyLeaves.seal();
    }

    public boolean isImmutable() {
        return this.leafIndexesAreImmutable.get();
    }

    public void release() {
        this.throwIfReleased();
        this.seal();
        this.releaseLock.lock();
        try {
            if (this.next.get() != null) {
                throw new IllegalStateException("Cannot release an intermediate version, must release the oldest");
            }
            this.released.set(true);
            this.wirePrevAndNext();
        }
        finally {
            this.releaseLock.unlock();
        }
        CLEANING_POOL.execute(() -> {
            VirtualNodeCache.purge(this.dirtyLeaves, this.keyToDirtyLeafIndex);
            VirtualNodeCache.purge(this.dirtyLeafPaths, this.pathToDirtyLeafIndex);
            VirtualNodeCache.purge(this.dirtyInternals, this.pathToDirtyInternalIndex);
            this.dirtyLeaves = null;
            this.dirtyLeafPaths = null;
            this.dirtyInternals = null;
        });
        if (LOG.isTraceEnabled()) {
            LOG.trace("Released {}", (Object)this.fastCopyVersion);
        }
    }

    public boolean isReleased() {
        return this.released.get();
    }

    public void merge() {
        this.releaseLock.lock();
        try {
            VirtualNodeCache<K, V> p = this.prev.get();
            if (p == null) {
                throw new IllegalStateException("Cannot merge with a null cache");
            }
            if (!p.internalIndexesAreImmutable.get() || !this.internalIndexesAreImmutable.get()) {
                throw new IllegalStateException("You can only merge caches that are sealed");
            }
            p.dirtyLeaves = new ConcurrentArray<Mutation<VirtualLeafRecord<K, V>>>(this.dirtyLeaves, p.dirtyLeaves);
            p.dirtyLeafPaths = new ConcurrentArray<Mutation<K>>(this.dirtyLeafPaths, p.dirtyLeafPaths);
            p.dirtyInternals = new ConcurrentArray<Mutation<VirtualInternalRecord>>(this.dirtyInternals, p.dirtyInternals);
            this.wirePrevAndNext();
        }
        finally {
            this.releaseLock.unlock();
            if (LOG.isTraceEnabled()) {
                LOG.trace("Merged version {}, {} dirty leaves, {} dirty internals", (Object)this.fastCopyVersion, (Object)this.dirtyLeaves.size(), (Object)this.dirtyInternals.size());
            }
        }
    }

    public void seal() {
        this.leafIndexesAreImmutable.set(true);
        this.internalIndexesAreImmutable.set(true);
        this.dirtyLeaves.seal();
        this.dirtyInternals.seal();
        this.dirtyLeafPaths.seal();
    }

    public void putLeaf(VirtualLeafRecord<K, V> leaf) {
        this.throwIfLeafImmutable();
        Objects.requireNonNull(leaf);
        K key = leaf.getKey();
        assert (key != null) : "Keys cannot be null";
        this.updatePaths(key, leaf.getPath(), this.pathToDirtyLeafIndex, this.dirtyLeafPaths);
        this.keyToDirtyLeafIndex.compute((VirtualKey)key, (BiFunction<VirtualKey, Mutation<VirtualLeafRecord<VirtualKey, Mutation>>, Mutation<VirtualLeafRecord<VirtualKey, Mutation>>>)((BiFunction<VirtualKey, Mutation, Mutation>)(k, mutations) -> this.mutate(leaf, (Mutation<VirtualLeafRecord<K, V>>)mutations)));
    }

    public void deleteLeaf(VirtualLeafRecord<K, V> leaf) {
        this.throwIfLeafImmutable();
        Objects.requireNonNull(leaf);
        this.clearLeafPath(leaf.getPath());
        K key = leaf.getKey();
        assert (key != null) : "Keys cannot be null";
        this.keyToDirtyLeafIndex.compute((VirtualKey)key, (BiFunction<VirtualKey, Mutation<VirtualLeafRecord<VirtualKey, Mutation>>, Mutation<VirtualLeafRecord<VirtualKey, Mutation>>>)((BiFunction<VirtualKey, Mutation, Mutation>)(k, mutations) -> {
            mutations = this.mutate(leaf, (Mutation<VirtualLeafRecord<K, V>>)mutations);
            mutations.deleted = true;
            assert (this.pathToDirtyLeafIndex.get((Object)Long.valueOf((long)leaf.getPath())).deleted) : "It should be deleted too";
            return mutations;
        }));
    }

    public void clearLeafPath(long path) {
        this.throwIfLeafImmutable();
        this.updatePaths(null, path, this.pathToDirtyLeafIndex, this.dirtyLeafPaths);
    }

    public VirtualLeafRecord<K, V> lookupLeafByKey(K key, boolean forModify) {
        Objects.requireNonNull(key);
        if (this.released.get()) {
            return null;
        }
        Mutation<VirtualLeafRecord<K, V>> mutation = this.lookup(this.keyToDirtyLeafIndex.get(key));
        if (mutation == null) {
            return null;
        }
        if (mutation.deleted) {
            return DELETED_LEAF_RECORD;
        }
        if (forModify && mutation.version < this.fastCopyVersion.get()) {
            assert (!this.leafIndexesAreImmutable.get()) : "You cannot create leaf records at this time!";
            VirtualLeafRecord leaf = new VirtualLeafRecord(((VirtualLeafRecord)mutation.value).getPath(), null, ((VirtualLeafRecord)mutation.value).getKey(), ((VirtualLeafRecord)mutation.value).getValue());
            this.updatePaths(key, leaf.getPath(), this.pathToDirtyLeafIndex, this.dirtyLeafPaths);
            this.keyToDirtyLeafIndex.compute((VirtualKey)key, (BiFunction<VirtualKey, Mutation<VirtualLeafRecord<VirtualKey, Mutation>>, Mutation<VirtualLeafRecord<VirtualKey, Mutation>>>)((BiFunction<VirtualKey, Mutation, Mutation>)(k, m) -> this.mutate(leaf, (Mutation<VirtualLeafRecord<K, V>>)m)));
            return leaf;
        }
        return (VirtualLeafRecord)mutation.value;
    }

    public VirtualLeafRecord<K, V> lookupLeafByPath(long path, boolean forModify) {
        if (this.released.get()) {
            return null;
        }
        Mutation<K> mutation = this.lookup(this.pathToDirtyLeafIndex.get(path));
        if (mutation == null) {
            return null;
        }
        return mutation.deleted ? DELETED_LEAF_RECORD : this.lookupLeafByKey((VirtualKey)mutation.value, forModify);
    }

    public Stream<VirtualLeafRecord<K, V>> dirtyLeaves(long firstLeafPath, long lastLeafPath) {
        if (!this.dirtyLeaves.isImmutable()) {
            throw new MutabilityException("Cannot call on a cache that is still mutable for dirty leaves");
        }
        AtomicReference lastSeen = new AtomicReference();
        return this.dirtyLeaves.sortedStream(this.dirtyLeafComparator()).filter(mutation -> {
            long path = ((VirtualLeafRecord)mutation.value).getPath();
            return path >= firstLeafPath && path <= lastLeafPath;
        }).filter(mutation -> VirtualNodeCache.dedupeByPath(mutation, lastSeen)).filter(mutation -> !mutation.deleted).map(mutation -> (VirtualLeafRecord)mutation.value);
    }

    public Stream<VirtualLeafRecord<K, V>> deletedLeaves() {
        if (!this.dirtyLeaves.isImmutable()) {
            throw new MutabilityException("Cannot call on a cache that is still mutable for dirty leaves");
        }
        AtomicReference lastSeen = new AtomicReference();
        return this.dirtyLeaves.sortedStream(this.deletedLeafComparator()).filter(mutation -> this.dedupeByKey((Mutation<VirtualLeafRecord<K, V>>)mutation, lastSeen)).filter(mutation -> mutation.deleted).map(mutation -> (VirtualLeafRecord)mutation.value);
    }

    public void putInternal(VirtualInternalRecord node) {
        this.throwIfInternalsImmutable();
        Objects.requireNonNull(node);
        this.updatePaths(node, node.getPath(), this.pathToDirtyInternalIndex, this.dirtyInternals);
    }

    public void deleteInternal(long path) {
        this.throwIfLeafImmutable();
        this.updatePaths(null, path, this.pathToDirtyInternalIndex, this.dirtyInternals);
    }

    public VirtualInternalRecord lookupInternalByPath(long path, boolean forModify) {
        if (this.released.get()) {
            return null;
        }
        Mutation<VirtualInternalRecord> mutation = this.lookup(this.pathToDirtyInternalIndex.get(path));
        if (mutation == null) {
            return null;
        }
        if (mutation.deleted) {
            return DELETED_INTERNAL_RECORD;
        }
        if (forModify && mutation.version < this.fastCopyVersion.get()) {
            assert (!this.internalIndexesAreImmutable.get()) : "You cannot create internal records at this time!";
            VirtualInternalRecord virtualRecord = new VirtualInternalRecord(path, null);
            this.updatePaths(virtualRecord, path, this.pathToDirtyInternalIndex, this.dirtyInternals);
            return virtualRecord;
        }
        return (VirtualInternalRecord)mutation.value;
    }

    public Stream<VirtualInternalRecord> dirtyInternals(long firstLeafPath) {
        if (!this.dirtyInternals.isImmutable()) {
            throw new MutabilityException("Cannot get the dirty internal records for a non-sealed cache.");
        }
        AtomicReference lastSeen = new AtomicReference();
        return this.dirtyInternals.seal().sortedStream(VirtualNodeCache.dirtyInternalComparator()).filter(mutation -> mutation.deleted || ((VirtualInternalRecord)mutation.value).getPath() < firstLeafPath).filter(mutation -> VirtualNodeCache.dedupeByPath(mutation, lastSeen)).filter(mutation -> !mutation.deleted).map(mutation -> (VirtualInternalRecord)mutation.value);
    }

    public long getClassId() {
        return 5275760189460016428L;
    }

    public void serialize(SerializableDataOutputStream out) throws IOException {
        if (!this.snapshot.get()) {
            throw new IllegalStateException("Trying to serialize a non-snapshot instance");
        }
        out.writeLong(this.fastCopyVersion.get());
        this.serializeKeyToDirtyLeafIndex(this.keyToDirtyLeafIndex, out);
        this.serializePathToDirtyLeafIndex(this.pathToDirtyLeafIndex, out);
        this.serializePathToDirtyInternalIndex(this.pathToDirtyInternalIndex, out);
    }

    public void deserialize(SerializableDataInputStream in, int version) throws IOException {
        this.fastCopyVersion.set(in.readLong());
        this.deserializeKeyToDirtyLeafIndex(this.keyToDirtyLeafIndex, in);
        this.deserializePathToDirtyLeafIndex(this.pathToDirtyLeafIndex, in);
        this.deserializePathToDirtyInternalIndex(this.pathToDirtyInternalIndex, in);
    }

    public int getVersion() {
        return 1;
    }

    public VirtualNodeCache<K, V> snapshot() {
        VirtualNodeCache<K, V> newSnapshot = new VirtualNodeCache<K, V>();
        this.setMapSnapshotAndArray(this.pathToDirtyInternalIndex, newSnapshot.pathToDirtyInternalIndex, newSnapshot.dirtyInternals);
        this.setMapSnapshotAndArray(this.pathToDirtyLeafIndex, newSnapshot.pathToDirtyLeafIndex, newSnapshot.dirtyLeafPaths);
        this.setMapSnapshotAndArray(this.keyToDirtyLeafIndex, newSnapshot.keyToDirtyLeafIndex, newSnapshot.dirtyLeaves);
        newSnapshot.snapshot.set(true);
        newSnapshot.fastCopyVersion.set(this.fastCopyVersion.get());
        newSnapshot.seal();
        return newSnapshot;
    }

    private void wirePrevAndNext() {
        VirtualNodeCache<K, V> n = this.next.get();
        VirtualNodeCache<K, V> p = this.prev.get();
        if (n != null) {
            n.prev.set(p);
        }
        if (p != null) {
            p.next.set(n);
        }
        this.next.set(null);
        this.prev.set(null);
    }

    private <T> void updatePaths(T value, long path, Map<Long, Mutation<T>> index, ConcurrentArray<Mutation<T>> dirtyPaths) {
        index.compute(path, (key, mutation) -> {
            Mutation<Object> nextMutation = mutation;
            Mutation previousMutation = null;
            while (nextMutation != null && nextMutation.version > this.fastCopyVersion.get()) {
                previousMutation = nextMutation;
                nextMutation = nextMutation.next;
            }
            if (nextMutation == null || nextMutation.version != this.fastCopyVersion.get()) {
                nextMutation = new Mutation<Object>(nextMutation, path, value, this.fastCopyVersion.get());
                nextMutation.deleted = value == null;
                dirtyPaths.add(nextMutation);
            } else {
                nextMutation.value = value;
                boolean bl = nextMutation.deleted = value == null;
            }
            if (previousMutation != null) {
                previousMutation.next = nextMutation;
            } else {
                mutation = nextMutation;
            }
            return mutation;
        });
    }

    private <T> Mutation<T> lookup(Mutation<T> mutation) {
        while (mutation != null) {
            if (mutation.version <= this.fastCopyVersion.get()) {
                return mutation;
            }
            mutation = mutation.next;
        }
        return null;
    }

    private Mutation<VirtualLeafRecord<K, V>> mutate(VirtualLeafRecord<K, V> leaf, Mutation<VirtualLeafRecord<K, V>> mutation) {
        if (mutation == null || mutation.version != this.fastCopyVersion.get()) {
            Mutation<VirtualLeafRecord<K, V>> newerMutation = new Mutation<VirtualLeafRecord<K, V>>(mutation, leaf.getKey(), leaf, this.fastCopyVersion.get());
            this.dirtyLeaves.add(newerMutation);
            mutation = newerMutation;
        } else if (mutation.value != leaf) {
            mutation.value = leaf;
            mutation.deleted = false;
        } else {
            mutation.deleted = false;
        }
        return mutation;
    }

    private static <T, U> void purge(ConcurrentArray<Mutation<U>> array, Map<T, Mutation<U>> index) {
        array.parallelTraverse(CLEANING_POOL, element -> index.compute(element.key, (key, mutation) -> {
            if (mutation == null || element.equals(mutation)) {
                return null;
            }
            Mutation m = mutation;
            while (m.next != null) {
                if (element.equals(m.next)) {
                    m.next = null;
                    break;
                }
                m = m.next;
            }
            return mutation;
        }));
    }

    private <R, S> void setMapSnapshotAndArray(Map<R, Mutation<S>> src, Map<R, Mutation<S>> dst, ConcurrentArray<Mutation<S>> array) {
        for (Map.Entry<R, Mutation<S>> entry : src.entrySet()) {
            Mutation<Object> mutation = entry.getValue();
            while (mutation != null && mutation.version > this.fastCopyVersion.get()) {
                mutation = mutation.next;
            }
            if (mutation == null) continue;
            dst.put(entry.getKey(), mutation);
            array.add(mutation);
        }
    }

    private void serializePathToDirtyInternalIndex(Map<Long, Mutation<VirtualInternalRecord>> map, SerializableDataOutputStream out) throws IOException {
        assert (this.snapshot.get()) : "Only snapshots can be serialized";
        out.writeInt(map.size());
        for (Map.Entry<Long, Mutation<VirtualInternalRecord>> entry : map.entrySet()) {
            out.writeLong(entry.getKey().longValue());
            Mutation<VirtualInternalRecord> mutation = entry.getValue();
            assert (mutation != null) : "Mutations cannot be null in a snapshot";
            assert (mutation.version <= this.fastCopyVersion.get()) : "Trying to serialize pathToDirtyInternalIndex with a version ahead";
            VirtualInternalRecord internalRecord = (VirtualInternalRecord)mutation.value;
            out.writeLong(mutation.version);
            out.writeBoolean(mutation.deleted);
            if (internalRecord == null) continue;
            out.writeLong(internalRecord.getPath());
            out.writeSerializable((SelfSerializable)internalRecord.getHash(), true);
        }
    }

    private void deserializePathToDirtyInternalIndex(Map<Long, Mutation<VirtualInternalRecord>> map, SerializableDataInputStream in) throws IOException {
        int sizeOfMap = in.readInt();
        for (int index = 0; index < sizeOfMap; ++index) {
            long key = in.readLong();
            long mutationVersion = in.readLong();
            boolean deleted = in.readBoolean();
            long path = -1L;
            Hash hash = null;
            if (!deleted) {
                path = in.readLong();
                hash = (Hash)in.readSerializable();
            }
            VirtualInternalRecord internalRecord = deleted ? null : new VirtualInternalRecord(path, hash);
            Mutation<VirtualInternalRecord> mutation = new Mutation<VirtualInternalRecord>(null, key, internalRecord, mutationVersion);
            mutation.deleted = deleted;
            map.put(key, mutation);
            this.dirtyInternals.add(mutation);
        }
    }

    private void serializePathToDirtyLeafIndex(Map<Long, Mutation<K>> map, SerializableDataOutputStream out) throws IOException {
        assert (this.snapshot.get()) : "Only snapshots can be serialized";
        out.writeInt(map.size());
        for (Map.Entry<Long, Mutation<K>> entry : map.entrySet()) {
            out.writeLong(entry.getKey().longValue());
            Mutation<K> mutation = entry.getValue();
            assert (mutation != null) : "Mutations cannot be null in a snapshot";
            assert (mutation.version <= this.fastCopyVersion.get()) : "Trying to serialize pathToDirtyLeafIndex with a version ahead";
            out.writeSerializable((SelfSerializable)mutation.value, true);
            out.writeLong(mutation.version);
            out.writeBoolean(mutation.deleted);
        }
    }

    private void deserializePathToDirtyLeafIndex(Map<Long, Mutation<K>> map, SerializableDataInputStream in) throws IOException {
        int sizeOfMap = in.readInt();
        for (int index = 0; index < sizeOfMap; ++index) {
            Long path = in.readLong();
            VirtualKey key = (VirtualKey)in.readSerializable();
            long mutationVersion = in.readLong();
            boolean deleted = in.readBoolean();
            Mutation<VirtualKey> mutation = new Mutation<VirtualKey>(null, path, key, mutationVersion);
            mutation.deleted = deleted;
            map.put(path, mutation);
            this.dirtyLeafPaths.add(mutation);
        }
    }

    private void serializeKeyToDirtyLeafIndex(Map<K, Mutation<VirtualLeafRecord<K, V>>> map, SerializableDataOutputStream out) throws IOException {
        assert (this.snapshot.get()) : "Only snapshots can be serialized";
        out.writeInt(map.size());
        for (Map.Entry<K, Mutation<VirtualLeafRecord<K, V>>> entry : map.entrySet()) {
            Mutation<VirtualLeafRecord<K, V>> mutation = entry.getValue();
            assert (mutation != null) : "Mutations cannot be null in a snapshot";
            assert (mutation.version <= this.fastCopyVersion.get()) : "Trying to serialize keyToDirtyLeafIndex with a version ahead";
            VirtualLeafRecord leaf = (VirtualLeafRecord)mutation.value;
            out.writeSerializable((SelfSerializable)leaf, false);
            out.writeSerializable((SelfSerializable)leaf.getHash(), true);
            out.writeLong(mutation.version);
            out.writeBoolean(mutation.deleted);
        }
    }

    private void deserializeKeyToDirtyLeafIndex(Map<K, Mutation<VirtualLeafRecord<K, V>>> map, SerializableDataInputStream in) throws IOException {
        int sizeOfMap = in.readInt();
        for (int index = 0; index < sizeOfMap; ++index) {
            VirtualLeafRecord leafRecord = (VirtualLeafRecord)in.readSerializable(false, VirtualLeafRecord::new);
            leafRecord.setHash((Hash)in.readSerializable());
            long mutationVersion = in.readLong();
            boolean deleted = in.readBoolean();
            Mutation<VirtualLeafRecord> mutation = new Mutation<VirtualLeafRecord>(null, leafRecord.getKey(), leafRecord, mutationVersion);
            mutation.deleted = deleted;
            map.put(leafRecord.getKey(), mutation);
            this.dirtyLeaves.add(mutation);
        }
    }

    private void throwIfLeafImmutable() {
        if (this.leafIndexesAreImmutable.get()) {
            throw new MutabilityException("This operation is not permitted on immutable leaves");
        }
    }

    private void throwIfInternalsImmutable() {
        if (this.internalIndexesAreImmutable.get()) {
            throw new MutabilityException("This operation is not permitted on immutable internals");
        }
    }

    private Comparator<Mutation<VirtualLeafRecord<K, V>>> dirtyLeafComparator() {
        return DIRTY_LEAF_COMPARATOR;
    }

    private Comparator<Mutation<VirtualLeafRecord<K, V>>> deletedLeafComparator() {
        return DELETED_LEAF_COMPARATOR;
    }

    private static Comparator<Mutation<VirtualInternalRecord>> dirtyInternalComparator() {
        return DIRTY_INTERNAL_COMPARATOR;
    }

    private static boolean dedupeByPath(Mutation<? extends VirtualRecord> mutation, AtomicReference<Mutation<? extends VirtualRecord>> lastSeen) {
        long path;
        assert (mutation != null) : "The mutation was unexpectedly null!";
        Mutation<? extends VirtualRecord> last = lastSeen.get();
        long lastPath = last == null || last.value == null ? Long.MAX_VALUE : ((VirtualRecord)last.value).getPath();
        long l = path = mutation.value == null ? Long.MAX_VALUE : ((VirtualRecord)mutation.value).getPath();
        if (last != null && lastPath == path) {
            return false;
        }
        lastSeen.set(mutation);
        return true;
    }

    private boolean dedupeByKey(Mutation<VirtualLeafRecord<K, V>> mutation, AtomicReference<Mutation<VirtualLeafRecord<K, V>>> lastSeen) {
        assert (mutation != null) : "The mutation was unexpectedly null!";
        assert (mutation.value != null) : "Key mutations never hold a null key!";
        Mutation<VirtualLeafRecord<K, V>> last = lastSeen.get();
        Object lastKey = last == null || last.value == null ? null : ((VirtualLeafRecord)last.value).getKey();
        Object key = ((VirtualLeafRecord)mutation.value).getKey();
        if (last != null && key.equals(lastKey)) {
            return false;
        }
        lastSeen.set(mutation);
        return true;
    }

    public String toDebugString() {
        StringBuilder builder = new StringBuilder();
        builder.append("VirtualNodeCache ").append(this).append("\n");
        builder.append("===================================\n");
        builder.append(this.toDebugStringChain()).append("\n");
        builder.append(this.toDebugStringIndex("keyToDirtyLeafIndex", this.keyToDirtyLeafIndex)).append("\n");
        builder.append(this.toDebugStringIndex("pathToDirtyLeafIndex", this.pathToDirtyLeafIndex)).append("\n");
        builder.append(this.toDebugStringIndex("pathToDirtyInternalIndex", this.pathToDirtyInternalIndex)).append("\n");
        builder.append(this.toDebugStringArray("dirtyLeaves", this.dirtyLeaves));
        builder.append(this.toDebugStringArray("dirtyLeafPaths", this.dirtyLeafPaths));
        builder.append(this.toDebugStringArray("dirtyInternals", this.dirtyInternals));
        return builder.toString();
    }

    private String toDebugStringChain() {
        VirtualNodeCache<K, V> prevCache;
        StringBuilder builder = new StringBuilder();
        builder.append("Copies:\n");
        builder.append("\t");
        VirtualNodeCache<K, V> firstCache = this;
        while ((prevCache = firstCache.prev.get()) != null) {
            firstCache = prevCache;
        }
        while (firstCache != null) {
            builder.append("[").append(firstCache.fastCopyVersion.get()).append(firstCache == this ? "*" : "").append("]->");
            firstCache = firstCache.next.get();
        }
        return builder.toString();
    }

    private String toDebugStringIndex(String indexName, Map<Object, Mutation> index) {
        StringBuilder builder = new StringBuilder();
        builder.append(indexName).append(":\n");
        index.forEach((key, mutation) -> {
            builder.append("\t").append(key).append(":==> ");
            while (mutation != null) {
                builder.append("[").append(mutation.key).append(",").append(mutation.value).append(",").append(mutation.deleted ? "D," : "").append("V").append(mutation.version).append(mutation.version == this.fastCopyVersion.get() ? "*" : "").append("]->");
                mutation = mutation.next;
            }
            builder.append("\n");
        });
        return builder.toString();
    }

    private String toDebugStringArray(String name, ConcurrentArray<Mutation> arr) {
        StringBuilder builder = new StringBuilder();
        builder.append(name).append(":\n");
        int size = arr.size();
        for (int i = 0; i < size; ++i) {
            Mutation mutation = arr.get(i);
            builder.append("\t").append(mutation.key).append(",").append(mutation.value).append(",").append(mutation.deleted ? "D," : "").append("V").append(mutation.version).append(mutation.version == this.fastCopyVersion.get() ? "*" : "").append("]\n");
        }
        return builder.toString();
    }

    private static final class Mutation<U> {
        private volatile Mutation<U> next;
        private final long version;
        private final Object key;
        private volatile U value;
        private volatile boolean deleted;

        Mutation(Mutation<U> next, Object key, U value, long version) {
            this.next = next;
            this.key = key;
            this.value = value;
            this.version = version;
        }
    }

    private static final class ClassVersion {
        public static final int ORIGINAL = 1;

        private ClassVersion() {
        }
    }

    private static final class MutationComparator<R extends VirtualRecord>
    implements Comparator<Mutation<R>> {
        private MutationComparator() {
        }

        @Override
        public int compare(Mutation<R> a, Mutation<R> b) {
            try {
                VirtualRecord bRec;
                long bPath;
                assert (a != null) : "Mutation 'a' was unexpectedly null!";
                assert (b != null) : "Mutation 'b' was unexpectedly null!";
                VirtualRecord aRec = (VirtualRecord)a.value;
                long aPath = aRec == null ? Long.MAX_VALUE : aRec.getPath();
                int order = Long.compare(aPath, bPath = (bRec = (VirtualRecord)b.value) == null ? Long.MAX_VALUE : bRec.getPath());
                if (order != 0) {
                    return order;
                }
                order = Long.compare(b.version, a.version);
                if (order != 0) {
                    return order;
                }
                if (a.deleted && !b.deleted) {
                    order = 1;
                } else if (!a.deleted && b.deleted) {
                    order = -1;
                }
                assert (order != 0 || a.deleted) : "Error: Found two mutations for the same version=" + a.version + " and path=" + aPath;
                return order;
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    private static final class DeletedMutationComparator<R extends VirtualLeafRecord<?, ?>>
    implements Comparator<Mutation<R>> {
        private DeletedMutationComparator() {
        }

        @Override
        public int compare(Mutation<R> a, Mutation<R> b) {
            try {
                assert (a != null) : "Mutation 'a' was unexpectedly null!";
                assert (b != null) : "Mutation 'b' was unexpectedly null!";
                VirtualLeafRecord aRec = (VirtualLeafRecord)a.value;
                VirtualLeafRecord bRec = (VirtualLeafRecord)b.value;
                assert (aRec != null) : "Records seen by DeletedMutationComparator cannot ever be null";
                assert (bRec != null) : "Records seen by DeletedMutationComparator cannot ever be null";
                Object aKey = aRec.getKey();
                Object bKey = bRec.getKey();
                assert (aKey != null) : "Keys seen by DeletedMutationComparator cannot ever be null";
                assert (bKey != null) : "Keys seen by DeletedMutationComparator cannot ever be null";
                int order = aKey.compareTo(bKey);
                if (order != 0) {
                    return order;
                }
                order = Long.compare(b.version, a.version);
                if (order != 0) {
                    return order;
                }
                return order;
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
    }
}

