/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.virtualmap.internal.hash;

import com.swirlds.virtualmap.VirtualKey;
import com.swirlds.virtualmap.VirtualValue;
import com.swirlds.virtualmap.internal.hash.HashJob;
import com.swirlds.virtualmap.internal.hash.HashingQueue;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;

final class ArrayHashingQueue<K extends VirtualKey<? super K>, V extends VirtualValue>
implements HashingQueue<K, V> {
    private final AtomicInteger size = new AtomicInteger();
    private HashJob<K, V>[] queue = new HashJob[0];
    private int capacity = 0;

    ArrayHashingQueue() {
    }

    void ensureCapacity(int capacity) {
        if (this.queue.length < capacity) {
            this.queue = new HashJob[capacity];
        }
        this.capacity = capacity;
        this.reset();
    }

    @Override
    public int size() {
        return this.size.get();
    }

    @Override
    public HashingQueue<K, V> reset() {
        this.size.set(0);
        return this;
    }

    @Override
    public HashJob<K, V> appendHashJob() {
        return this.getForModify(this.size.getAndIncrement());
    }

    @Override
    public HashJob<K, V> addHashJob(int index) {
        this.size.updateAndGet(s -> s <= index ? index + 1 : s);
        return this.getForModify(index);
    }

    @Override
    public HashJob<K, V> get(int index) {
        assert (index < this.size.get()) : "Unexpected index out of bounds " + index;
        return this.queue[index];
    }

    HashJob<K, V> getForModify(int index) {
        assert (index < this.size.get()) : "Unexpected index out of bounds " + index;
        assert (index < this.capacity) : "Unexpected index out of bounds of capacity " + index;
        HashJob<K, V> job = this.queue[index];
        if (job == null) {
            job = new HashJob();
            this.queue[index] = job;
        } else {
            job.reset();
        }
        return job;
    }

    @Override
    public Stream<HashJob<K, V>> stream() {
        return Arrays.stream(this.queue, 0, this.size());
    }
}

