/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.virtualmap.internal.hash;

import com.swirlds.virtualmap.VirtualKey;
import com.swirlds.virtualmap.VirtualValue;
import com.swirlds.virtualmap.internal.hash.HashJob;
import com.swirlds.virtualmap.internal.hash.HashingQueue;
import java.util.Objects;
import java.util.stream.Stream;

final class CompoundHashingQueue<K extends VirtualKey<? super K>, V extends VirtualValue>
implements HashingQueue<K, V> {
    private final HashingQueue<K, V> queue1;
    private final HashingQueue<K, V> queue2;

    CompoundHashingQueue(HashingQueue<K, V> q1, HashingQueue<K, V> q2) {
        this.queue1 = Objects.requireNonNull(q1);
        this.queue2 = Objects.requireNonNull(q2);
    }

    @Override
    public int size() {
        return this.queue1.size() + this.queue2.size();
    }

    @Override
    public HashingQueue<K, V> reset() {
        this.queue1.reset();
        this.queue2.reset();
        return this;
    }

    @Override
    public HashJob<K, V> appendHashJob() {
        return this.queue1.appendHashJob();
    }

    @Override
    public HashJob<K, V> addHashJob(int index) {
        return this.queue1.addHashJob(index);
    }

    @Override
    public HashJob<K, V> get(int index) {
        int size1 = this.queue1.size();
        return index < size1 ? this.queue1.get(index) : this.queue2.get(index - size1);
    }

    @Override
    public Stream<HashJob<K, V>> stream() {
        return Stream.concat(this.queue1.stream(), this.queue2.stream());
    }
}

