/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.virtualmap.internal.hash;

import com.swirlds.common.crypto.CryptoFactory;
import com.swirlds.common.crypto.Cryptography;
import com.swirlds.common.crypto.Hash;
import com.swirlds.common.crypto.HashBuilder;
import com.swirlds.common.crypto.Hashable;
import com.swirlds.virtualmap.VirtualKey;
import com.swirlds.virtualmap.VirtualValue;
import com.swirlds.virtualmap.datasource.VirtualInternalRecord;
import com.swirlds.virtualmap.datasource.VirtualLeafRecord;
import java.util.Objects;

final class HashJob<K extends VirtualKey<? super K>, V extends VirtualValue>
implements Hashable {
    private static final Cryptography CRYPTO = CryptoFactory.getInstance();
    private static final Hash NULL_HASH = CRYPTO.getNullHash();
    private long path;
    private Hash left;
    private Hash right;
    private VirtualLeafRecord<K, V> leaf;
    private VirtualInternalRecord internal;
    private volatile Hash hash;

    HashJob() {
    }

    void dirtyLeaf(long path, VirtualLeafRecord<K, V> leaf) {
        this.path = path;
        this.leaf = leaf;
    }

    void dirtyInternal(long path, VirtualInternalRecord internal, Hash left, Hash right) {
        this.path = path;
        this.internal = internal;
        this.left = left;
        this.right = right;
    }

    void copy(HashJob<K, V> other) {
        this.path = other.path;
        this.left = other.left;
        this.right = other.right;
        this.leaf = other.leaf;
        this.internal = other.internal;
        this.hash = other.hash;
    }

    void reset() {
        this.path = -1L;
        this.right = null;
        this.left = null;
        this.hash = null;
        this.leaf = null;
        this.internal = null;
    }

    void hash(HashBuilder builder) {
        if (this.leaf != null) {
            this.hash = CRYPTO.digestSync(this.leaf);
            this.leaf.setHash(this.hash);
        } else {
            Objects.requireNonNull(this.internal);
            long classId = this.path == 0L ? 5367589755328273141L : -5826388714229745985L;
            int serId = this.path == 0L ? 1 : 1;
            Hash leftHash = this.left == null ? NULL_HASH : this.left;
            Hash rightHash = this.right == null ? NULL_HASH : this.right;
            builder.reset();
            builder.update(classId);
            builder.update(serId);
            builder.update(leftHash);
            builder.update(rightHash);
            this.hash = builder.build();
            this.internal.setHash(this.hash);
        }
    }

    public Hash getHash() {
        return this.hash;
    }

    public void setHash(Hash hash) {
        this.hash = hash;
    }

    VirtualInternalRecord getInternal() {
        return this.internal;
    }

    long getPath() {
        return this.path;
    }

    VirtualLeafRecord<K, V> getLeaf() {
        return this.leaf;
    }
}

