/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.virtualmap.internal.hash;

import com.swirlds.virtualmap.VirtualKey;
import com.swirlds.virtualmap.VirtualValue;
import com.swirlds.virtualmap.internal.hash.HashJob;
import java.util.Objects;
import java.util.stream.Stream;

interface HashingQueue<K extends VirtualKey<? super K>, V extends VirtualValue> {
    public int size();

    public HashingQueue<K, V> reset();

    default public void copyFrom(HashingQueue<K, V> queue) {
        Objects.requireNonNull(queue);
        this.reset();
        int size = queue.size();
        for (int i = 0; i < size; ++i) {
            this.appendHashJob().copy(queue.get(i));
        }
    }

    public HashJob<K, V> appendHashJob();

    public HashJob<K, V> addHashJob(int var1);

    public HashJob<K, V> get(int var1);

    public Stream<HashJob<K, V>> stream();
}

