/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.virtualmap.internal.hash;

import java.util.Iterator;
import java.util.Objects;

final class PeekIterator<T>
implements Iterator<T> {
    private final Iterator<T> itr;
    private T next;

    PeekIterator(Iterator<T> itr) {
        this.itr = Objects.requireNonNull(itr);
    }

    @Override
    public boolean hasNext() {
        return this.next != null || this.itr.hasNext();
    }

    @Override
    public T next() {
        if (this.next != null) {
            T ret = this.next;
            this.next = null;
            return ret;
        }
        return this.itr.next();
    }

    T peek() {
        if (this.next == null) {
            this.next = this.itr.next();
        }
        return this.next;
    }
}

