/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.virtualmap.internal.hash;

import com.swirlds.common.crypto.Cryptography;
import com.swirlds.common.crypto.Hash;
import com.swirlds.common.crypto.HashBuilder;
import com.swirlds.common.threading.ThreadConfiguration;
import com.swirlds.logging.LogMarker;
import com.swirlds.virtualmap.VirtualKey;
import com.swirlds.virtualmap.VirtualMapSettingsFactory;
import com.swirlds.virtualmap.VirtualValue;
import com.swirlds.virtualmap.datasource.VirtualInternalRecord;
import com.swirlds.virtualmap.datasource.VirtualLeafRecord;
import com.swirlds.virtualmap.internal.Path;
import com.swirlds.virtualmap.internal.hash.ArrayHashingQueue;
import com.swirlds.virtualmap.internal.hash.CompoundHashingQueue;
import com.swirlds.virtualmap.internal.hash.HashJob;
import com.swirlds.virtualmap.internal.hash.HashingQueue;
import com.swirlds.virtualmap.internal.hash.PeekIterator;
import com.swirlds.virtualmap.internal.hash.VirtualHashListener;
import java.util.Iterator;
import java.util.Objects;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.LongFunction;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class VirtualHasher<K extends VirtualKey<? super K>, V extends VirtualValue> {
    private static final Logger LOG = LogManager.getLogger(VirtualHasher.class);
    private static final int HASHING_THREAD_COUNT = VirtualMapSettingsFactory.get().getNumHashThreads();
    private static final ExecutorService HASHING_POOL = Executors.newCachedThreadPool(new ThreadConfiguration().setThreadGroup(new ThreadGroup("virtual-map-hashers")).setComponent("virtual-map").setThreadName("hasher").setExceptionHandler((t, ex) -> LOG.error(LogMarker.EXCEPTION.getMarker(), "Uncaught exception during hashing", ex)).buildFactory());
    private static final ThreadLocal<HashBuilder> HASH_BUILDER_THREAD_LOCAL = ThreadLocal.withInitial(() -> new HashBuilder(Cryptography.DEFAULT_DIGEST_TYPE));
    private final ArrayHashingQueue<K, V> queue1;
    private final ArrayHashingQueue<K, V> queue2;
    private final ArrayHashingQueue<K, V> maxRankStopQueue;
    private final ArrayHashingQueue<K, V> minRankStopQueue;
    private final ArrayHashingQueue<K, V> lastQueue;
    private AtomicBoolean shutdown = new AtomicBoolean(false);

    public VirtualHasher() {
        this.queue1 = new ArrayHashingQueue();
        this.queue2 = new ArrayHashingQueue();
        this.maxRankStopQueue = new ArrayHashingQueue();
        this.lastQueue = new ArrayHashingQueue();
        this.minRankStopQueue = new ArrayHashingQueue();
    }

    public void shutdown() {
        this.shutdown.set(true);
    }

    public Hash hash(LongFunction<VirtualLeafRecord<K, V>> leafReader, LongFunction<VirtualInternalRecord> internalReader, Iterator<VirtualLeafRecord<K, V>> sortedDirtyLeaves, long firstLeafPath, long lastLeafPath) {
        return this.hash(leafReader, internalReader, sortedDirtyLeaves, firstLeafPath, lastLeafPath, null);
    }

    public Hash hash(LongFunction<VirtualLeafRecord<K, V>> leafReader, LongFunction<VirtualInternalRecord> internalReader, Iterator<VirtualLeafRecord<K, V>> sortedDirtyLeaves, long firstLeafPath, long lastLeafPath, VirtualHashListener<K, V> listener) {
        long reservedLastLeafCount;
        if (firstLeafPath < 1L || lastLeafPath < 1L) {
            return null;
        }
        PeekIterator<VirtualLeafRecord<K, V>> itr = new PeekIterator<VirtualLeafRecord<K, V>>(sortedDirtyLeaves);
        if (!itr.hasNext()) {
            return null;
        }
        if (listener == null) {
            listener = new VirtualHashListener<K, V>(){};
        }
        int minLeafRank = Path.getRank(firstLeafPath);
        int maxLeafRank = Path.getRank(lastLeafPath);
        int stopRank = maxLeafRank >> 2;
        int minRankSegmentSize = 1 << minLeafRank - stopRank;
        int maxRankSegmentSize = 1 << maxLeafRank - stopRank;
        int maxQueueSize = maxRankSegmentSize * 2;
        this.queue1.ensureCapacity(maxQueueSize);
        this.queue2.ensureCapacity(maxQueueSize);
        this.minRankStopQueue.ensureCapacity(maxRankSegmentSize);
        this.maxRankStopQueue.ensureCapacity(maxRankSegmentSize);
        this.lastQueue.ensureCapacity(minRankSegmentSize);
        long firstLeafIndexInRank = Path.getIndexInRank(firstLeafPath);
        long firstLeafOffsetWithinSegment = firstLeafIndexInRank % (long)minRankSegmentSize;
        if (minLeafRank != maxLeafRank && firstLeafOffsetWithinSegment > 0L) {
            this.readLeavesInSegment(itr, this.lastQueue, firstLeafPath + ((long)minRankSegmentSize - firstLeafOffsetWithinSegment));
        }
        long l = reservedLastLeafCount = this.lastQueue.size() == 0 ? 0L : firstLeafOffsetWithinSegment * 2L;
        assert (reservedLastLeafCount <= 0L ? this.lastQueue.size() == 0 : this.lastQueue.size() > 0) : "Improper computation of reservedLastLeafCount";
        listener.onHashingStarted();
        long lastPath = -1L;
        while (itr.hasNext()) {
            VirtualLeafRecord<K, V> next = itr.peek();
            long path = next.getPath();
            int rank = Path.getRank(path);
            if (path < lastPath) {
                throw new IllegalStateException("The paths in the iterator must be strictly increasing! lastPath=" + lastPath + ", path=" + path);
            }
            lastPath = path;
            assert (path >= firstLeafPath && path <= lastLeafPath) : "Invalid path lies outside the leaf path range " + path;
            if (rank == maxLeafRank && path >= lastLeafPath - reservedLastLeafCount) break;
            long segmentSize = rank == minLeafRank ? (long)minRankSegmentSize : (long)maxRankSegmentSize;
            long eofPath = Math.min((1L << rank + 1) - 1L, lastLeafPath - reservedLastLeafCount + 1L);
            HashingQueue<K, V> wq = this.queue1.reset();
            this.accumulate(itr, wq, path - Path.getIndexInRank(path) % segmentSize, segmentSize, eofPath);
            HashingQueue<K, V> pq = this.queue2.reset();
            ArrayHashingQueue<K, V> sq = rank == maxLeafRank ? this.maxRankStopQueue : this.minRankStopQueue;
            listener.onBatchStarted();
            this.hashSubTree(leafReader, internalReader, listener, wq, pq, null, sq, firstLeafPath, lastLeafPath, rank, stopRank);
            listener.onBatchCompleted();
        }
        if (itr.hasNext() || this.lastQueue.size() > 0) {
            HashingQueue<K, V> wq = this.queue1.reset();
            this.readLeavesInSegment(itr, wq, lastLeafPath + 1L);
            HashingQueue<K, V> pq = this.queue2.reset();
            listener.onBatchStarted();
            this.hashSubTree(leafReader, internalReader, listener, wq, pq, this.lastQueue, this.maxRankStopQueue, firstLeafPath, lastLeafPath, maxLeafRank, stopRank);
            listener.onBatchCompleted();
        }
        listener.onBatchStarted();
        this.hashSubTree(leafReader, internalReader, listener, new CompoundHashingQueue<K, V>(this.maxRankStopQueue, this.minRankStopQueue), this.queue1.reset(), null, this.queue2.reset(), firstLeafPath, lastLeafPath, stopRank, 0);
        assert (this.queue2.size() == 1) : "There must only be a single hash job in the root queue!! Current size = " + this.queue2.size();
        HashJob<K, V> rootJob = this.queue2.get(0);
        rootJob.hash(HASH_BUILDER_THREAD_LOCAL.get());
        listener.onRankStarted();
        listener.onInternalHashed(rootJob.getInternal());
        listener.onRankCompleted();
        listener.onBatchCompleted();
        listener.onHashingCompleted();
        return rootJob.getHash();
    }

    private void hashSubTree(LongFunction<VirtualLeafRecord<K, V>> leafReader, LongFunction<VirtualInternalRecord> internalReader, VirtualHashListener<K, V> listener, HashingQueue<K, V> wq, HashingQueue<K, V> pq, HashingQueue<K, V> lq, HashingQueue<K, V> sq, long firstLeafPath, long lastLeafPath, int startRank, int stopRank) {
        assert (wq != null && pq != null && sq != null) : "Unexpected null for pq or wq or sq";
        assert (startRank >= 0) : "startRank was negative!";
        assert (stopRank >= 0) : "stopRank was negative!";
        assert (listener != null) : "Listener cannot be null in hashSubTree";
        Objects.requireNonNull(leafReader, "leaf reader is not permitted to be null");
        Objects.requireNonNull(internalReader, "internal reader is not permitted to be null");
        if (startRank == stopRank) {
            assert (startRank == 1 || startRank == 0) : "Expected rank 0 or 1, was " + startRank;
            sq.copyFrom(wq);
            return;
        }
        ConcurrentLinkedDeque exceptions = new ConcurrentLinkedDeque();
        for (int rank = startRank; rank > stopRank; --rank) {
            boolean hasLastQueue;
            HashingQueue workQueue = wq;
            HashingQueue pendingQueue = rank == stopRank + 1 ? sq : pq;
            int threadCount = Math.min(workQueue.size(), Math.min(HASHING_THREAD_COUNT, 1 << rank - stopRank));
            boolean bl = hasLastQueue = lq != null && lq.size() > 0;
            assert (workQueue.size() > 0 || hasLastQueue) : "Work queue is empty for rank " + rank;
            assert (threadCount > 0 || hasLastQueue) : "Thread count is zero for rank " + rank + ", max hashing threads configured to be " + HASHING_THREAD_COUNT;
            CountDownLatch latch = new CountDownLatch(threadCount);
            int offset = pendingQueue == sq ? sq.size() : 0;
            int workQueueSize = workQueue.size();
            int i = 0;
            while (i < threadCount) {
                int threadNum = i++;
                HASHING_POOL.execute(() -> {
                    HashBuilder hashBuilder = HASH_BUILDER_THREAD_LOCAL.get();
                    try {
                        int j = 0;
                        int unitIndex = 0;
                        while (j < workQueueSize) {
                            boolean both;
                            HashJob hashJob = workQueue.get(j);
                            HashJob nextJob = j < workQueueSize - 1 ? workQueue.get(j + 1) : null;
                            long nodePath = hashJob.getPath();
                            assert (nodePath != 0L && Path.getRank(nodePath) != stopRank);
                            assert (nodePath != -1L);
                            long siblingPath = Path.getSiblingPath(nodePath);
                            assert (siblingPath != 0L && Path.getRank(nodePath) != stopRank);
                            assert (siblingPath != -1L);
                            boolean bl = both = nextJob != null && nextJob.getPath() == siblingPath;
                            if (both) {
                                ++j;
                            }
                            if (unitIndex % threadCount == threadNum) {
                                hashJob.hash(hashBuilder);
                                long parentPath = Path.getParentPath(nodePath);
                                VirtualInternalRecord internal = new VirtualInternalRecord(parentPath);
                                int pendingQueueIndex = offset + unitIndex;
                                if (both) {
                                    nextJob.hash(hashBuilder);
                                    pendingQueue.addHashJob(pendingQueueIndex).dirtyInternal(parentPath, internal, hashJob.getHash(), nextJob.getHash());
                                } else if (nodePath == firstLeafPath && nodePath == lastLeafPath) {
                                    pendingQueue.addHashJob(pendingQueueIndex).dirtyInternal(parentPath, internal, hashJob.getHash(), null);
                                } else if (siblingPath >= firstLeafPath) {
                                    VirtualLeafRecord sibling = Objects.requireNonNull((VirtualLeafRecord)leafReader.apply(siblingPath), "Failed to find leaf for " + siblingPath + ", which is a sibling of " + nodePath);
                                    siblingHash = sibling.getHash();
                                    Objects.requireNonNull(siblingHash, "Failed to find leaf hash for " + siblingPath + ", which is a sibling of " + nodePath);
                                    leftHash = nodePath < siblingPath ? hashJob.getHash() : siblingHash;
                                    rightHash = nodePath < siblingPath ? siblingHash : hashJob.getHash();
                                    pendingQueue.addHashJob(pendingQueueIndex).dirtyInternal(parentPath, internal, leftHash, rightHash);
                                } else {
                                    VirtualInternalRecord siblingInternal = (VirtualInternalRecord)internalReader.apply(siblingPath);
                                    assert (siblingInternal != null) : "Should never be able to be null";
                                    siblingHash = siblingInternal.getHash();
                                    Objects.requireNonNull(siblingHash, "Failed to find internal hash for " + siblingPath + ", which is a sibling of " + nodePath);
                                    leftHash = nodePath < siblingPath ? hashJob.getHash() : siblingHash;
                                    rightHash = nodePath < siblingPath ? siblingHash : hashJob.getHash();
                                    pendingQueue.addHashJob(pendingQueueIndex).dirtyInternal(parentPath, internal, leftHash, rightHash);
                                }
                            }
                            ++j;
                            ++unitIndex;
                        }
                    }
                    catch (Throwable exception) {
                        exceptions.add(exception);
                    }
                    finally {
                        latch.countDown();
                    }
                });
            }
            try {
                latch.await();
            }
            catch (InterruptedException ex) {
                if (!this.shutdown.get()) {
                    LOG.error(LogMarker.EXCEPTION.getMarker(), "Failed to wait for all hashing threads", (Throwable)ex);
                }
                Thread.currentThread().interrupt();
            }
            if (!exceptions.isEmpty()) {
                if (this.shutdown.get()) {
                    return;
                }
                RuntimeException exception = new RuntimeException("exception encountered while hashing virtual tree", (Throwable)exceptions.remove());
                for (Throwable t : exceptions) {
                    exception.addSuppressed(t);
                }
                throw exception;
            }
            int pendingQueueSize = pendingQueue.size();
            int maximumPendingQueueSize = 1 << rank;
            assert ((pendingQueueSize > 0 || hasLastQueue) && pendingQueueSize <= maximumPendingQueueSize) : "Pending queue has an invalid size of " + pendingQueueSize + " at rank " + rank;
            listener.onRankStarted();
            wq.stream().forEach(j -> {
                VirtualLeafRecord leaf = j.getLeaf();
                if (leaf != null) {
                    listener.onLeafHashed(leaf);
                } else {
                    listener.onInternalHashed(j.getInternal());
                }
            });
            listener.onRankCompleted();
            HashingQueue tmp = wq;
            wq = pq;
            pq = tmp;
            if (lq != null) {
                HashingQueue q = wq;
                lq.stream().forEach(job -> q.appendHashJob().dirtyLeaf(job.getPath(), job.getLeaf()));
                lq = null;
            }
            pq.reset();
        }
    }

    private void readLeavesInSegment(PeekIterator<VirtualLeafRecord<K, V>> itr, HashingQueue<K, V> queue, long eofPath) {
        VirtualLeafRecord<K, V> nextLeaf;
        long path;
        while (itr.hasNext() && (path = (nextLeaf = itr.peek()).getPath()) < eofPath) {
            queue.appendHashJob().dirtyLeaf(path, itr.next());
        }
    }

    private void accumulate(PeekIterator<VirtualLeafRecord<K, V>> itr, HashingQueue<K, V> queue, long segmentStart, long segmentSize, long eofPath) {
        while ((long)queue.size() < segmentSize) {
            this.readLeavesInSegment(itr, queue, Math.min(segmentStart + segmentSize, eofPath));
            if (!itr.hasNext() || itr.peek().getPath() >= eofPath) {
                return;
            }
            segmentStart += segmentSize;
        }
    }

    public Hash emptyRootHash() {
        HashJob hashJob = new HashJob();
        hashJob.dirtyInternal(0L, new VirtualInternalRecord(0L), null, null);
        hashJob.hash(new HashBuilder(Cryptography.DEFAULT_DIGEST_TYPE));
        return hashJob.getHash();
    }
}

