/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.virtualmap.internal.merkle;

import com.swirlds.virtualmap.VirtualKey;
import com.swirlds.virtualmap.VirtualValue;
import com.swirlds.virtualmap.datasource.VirtualDataSource;
import com.swirlds.virtualmap.datasource.VirtualInternalRecord;
import com.swirlds.virtualmap.datasource.VirtualLeafRecord;
import com.swirlds.virtualmap.datasource.VirtualRecord;
import com.swirlds.virtualmap.internal.RecordAccessor;
import com.swirlds.virtualmap.internal.StateAccessor;
import com.swirlds.virtualmap.internal.cache.VirtualNodeCache;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Objects;

public class RecordAccessorImpl<K extends VirtualKey<? super K>, V extends VirtualValue>
implements RecordAccessor<K, V> {
    private final StateAccessor state;
    private final VirtualNodeCache<K, V> cache;
    private final VirtualDataSource<K, V> dataSource;

    public RecordAccessorImpl(StateAccessor state, VirtualNodeCache<K, V> cache, VirtualDataSource<K, V> dataSource) {
        this.state = Objects.requireNonNull(state);
        this.cache = Objects.requireNonNull(cache);
        this.dataSource = dataSource;
    }

    public StateAccessor getState() {
        return this.state;
    }

    @Override
    public VirtualNodeCache<K, V> getCache() {
        return this.cache;
    }

    @Override
    public VirtualDataSource<K, V> getDataSource() {
        return this.dataSource;
    }

    @Override
    public VirtualRecord findRecord(long path) {
        assert (path != -1L);
        if (path >= 0L && path < this.state.getFirstLeafPath()) {
            return this.findInternalRecord(path);
        }
        assert (path >= this.state.getFirstLeafPath());
        return this.findLeafRecord(path, false);
    }

    @Override
    public VirtualInternalRecord findInternalRecord(long path) {
        assert (path >= 0L);
        VirtualInternalRecord node = this.cache.lookupInternalByPath(path, false);
        if (node == null) {
            try {
                node = this.dataSource.loadInternalRecord(path);
            }
            catch (IOException e) {
                throw new UncheckedIOException("Failed to read an internal node record from the data source", e);
            }
        }
        return node == VirtualNodeCache.DELETED_INTERNAL_RECORD ? null : node;
    }

    @Override
    public VirtualLeafRecord<K, V> findLeafRecord(K key, boolean copy) {
        VirtualLeafRecord<K, V> rec = this.cache.lookupLeafByKey(key, copy);
        if (rec == null) {
            try {
                rec = this.dataSource.loadLeafRecord(key);
                if (rec != null && copy) {
                    assert (rec.getKey().equals(key)) : "The key we found from the DB does not match the one we were looking for! key=" + key;
                    this.cache.putLeaf(rec);
                }
            }
            catch (IOException ex) {
                throw new UncheckedIOException("Failed to read a leaf record from the data source by key", ex);
            }
        }
        return rec == VirtualNodeCache.DELETED_LEAF_RECORD ? null : rec;
    }

    @Override
    public VirtualLeafRecord<K, V> findLeafRecord(long path, boolean copy) {
        assert (path != -1L);
        assert (path != 0L);
        if (path < this.state.getFirstLeafPath() || path > this.state.getLastLeafPath()) {
            return null;
        }
        VirtualLeafRecord<K, V> rec = this.cache.lookupLeafByPath(path, copy);
        if (rec == null) {
            try {
                rec = this.dataSource.loadLeafRecord(path);
                if (rec != null && copy) {
                    this.cache.putLeaf(rec);
                }
            }
            catch (IOException ex) {
                throw new UncheckedIOException("Failed to read a leaf record from the data source by path", ex);
            }
        }
        return rec == VirtualNodeCache.DELETED_LEAF_RECORD ? null : rec;
    }
}

