/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.virtualmap.internal.merkle;

import com.swirlds.common.merkle.MerkleInternal;
import com.swirlds.common.merkle.MerkleNode;
import com.swirlds.common.merkle.io.SerializationStrategy;
import com.swirlds.common.merkle.route.MerkleRoute;
import com.swirlds.virtualmap.VirtualKey;
import com.swirlds.virtualmap.VirtualValue;
import com.swirlds.virtualmap.datasource.VirtualInternalRecord;
import com.swirlds.virtualmap.datasource.VirtualLeafRecord;
import com.swirlds.virtualmap.datasource.VirtualRecord;
import com.swirlds.virtualmap.internal.Path;
import com.swirlds.virtualmap.internal.merkle.VirtualLeafNode;
import com.swirlds.virtualmap.internal.merkle.VirtualNode;
import com.swirlds.virtualmap.internal.merkle.VirtualRootNode;
import java.io.IOException;
import java.util.List;
import java.util.Set;

public final class VirtualInternalNode<K extends VirtualKey<? super K>, V extends VirtualValue>
extends VirtualNode<K, V, VirtualInternalRecord>
implements MerkleInternal {
    private static final int NUMBER_OF_CHILDREN = 2;
    public static final long CLASS_ID = -5826388714229745985L;
    public static final int SERIALIZATION_VERSION = 1;
    private static final Set<SerializationStrategy> STRATEGIES = Set.of();

    public VirtualInternalNode() {
    }

    public VirtualInternalNode(VirtualRootNode<K, V> root, VirtualInternalRecord virtualRecord) {
        super(root, virtualRecord);
    }

    public int getNumberOfChildren() {
        return 2;
    }

    public <T extends MerkleNode> T getChild(int i) {
        VirtualNode<K, V, VirtualRecord> node;
        if (i == 0) {
            node = this.getLeft();
        } else if (i == 1) {
            node = this.getRight();
        } else {
            return null;
        }
        if (node == null) {
            return null;
        }
        long targetPath = ((VirtualRecord)node.virtualRecord).getPath();
        List<Integer> routePath = Path.getRouteStepsFromRoot(targetPath);
        MerkleRoute nodeRoute = this.root.getRoute().extendRoute(routePath);
        node.setRoute(nodeRoute);
        return (T)((Object)node);
    }

    public void setChild(int index, MerkleNode merkleNode) {
        throw new UnsupportedOperationException();
    }

    public void setChild(int index, MerkleNode merkleNode, MerkleRoute merkleRoute, boolean mayBeImmutable) {
        throw new UnsupportedOperationException();
    }

    private VirtualNode<K, V, ? extends VirtualRecord> getLeft() {
        return this.getChild(Path.getLeftChildPath(((VirtualInternalRecord)this.virtualRecord).getPath()));
    }

    private VirtualNode<K, V, ? extends VirtualRecord> getRight() {
        return this.getChild(Path.getRightChildPath(((VirtualInternalRecord)this.virtualRecord).getPath()));
    }

    private VirtualNode<K, V, ? extends VirtualRecord> getChild(long childPath) {
        if (childPath < this.root.getState().getFirstLeafPath()) {
            return this.getInternalNode(childPath);
        }
        return this.getLeafNode(childPath);
    }

    private VirtualInternalNode<K, V> getInternalNode(long path) {
        assert (path != -1L) : "Cannot happen. Path will be a child of virtual record path every time.";
        assert (path < this.root.getState().getFirstLeafPath());
        VirtualInternalRecord rec = this.root.getCache().lookupInternalByPath(path, false);
        if (rec == null) {
            try {
                rec = this.root.getDataSource().loadInternalRecord(path);
                if (rec == null) {
                    return new VirtualInternalNode<K, V>(this.root, new VirtualInternalRecord(path));
                }
            }
            catch (IOException ex) {
                throw new RuntimeException("Failed to read a internal record from the data source", ex);
            }
        }
        return new VirtualInternalNode<K, V>(this.root, rec);
    }

    private VirtualLeafNode<K, V> getLeafNode(long path) {
        assert (path != -1L);
        assert (path != 0L);
        if (path < this.root.getState().getFirstLeafPath() || path > this.root.getState().getLastLeafPath()) {
            return null;
        }
        VirtualLeafRecord rec = this.root.getCache().lookupLeafByPath(path, false);
        if (rec == null) {
            try {
                rec = this.root.getDataSource().loadLeafRecord(path);
                if (rec == null) {
                    throw new IllegalStateException("Attempted to read from disk but couldn't find the leaf.");
                }
            }
            catch (IOException ex) {
                throw new RuntimeException("Failed to read a leaf record from the data source", ex);
            }
        }
        return new VirtualLeafNode(this.root, rec);
    }

    public Set<SerializationStrategy> supportedSerialization(int version) {
        return STRATEGIES;
    }

    public VirtualInternalNode<K, V> copy() {
        throw new UnsupportedOperationException("Don't use this. Need a map pointer.");
    }

    public long getClassId() {
        return -5826388714229745985L;
    }

    public int getVersion() {
        return 1;
    }

    public String toString() {
        return "VirtualInternalNode{" + this.virtualRecord + "}";
    }
}

