/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.virtualmap.internal.merkle;

import com.swirlds.common.io.SelfSerializable;
import com.swirlds.common.io.SerializableDataInputStream;
import com.swirlds.common.io.SerializableDataOutputStream;
import com.swirlds.common.merkle.MerkleLeaf;
import com.swirlds.common.merkle.io.SerializationStrategy;
import com.swirlds.virtualmap.VirtualKey;
import com.swirlds.virtualmap.VirtualValue;
import com.swirlds.virtualmap.datasource.VirtualLeafRecord;
import com.swirlds.virtualmap.datasource.VirtualRecord;
import com.swirlds.virtualmap.internal.merkle.VirtualNode;
import com.swirlds.virtualmap.internal.merkle.VirtualRootNode;
import java.io.IOException;
import java.util.Set;

public final class VirtualLeafNode<K extends VirtualKey<? super K>, V extends VirtualValue>
extends VirtualNode<K, V, VirtualLeafRecord<K, V>>
implements MerkleLeaf {
    public static final long CLASS_ID = 5302557153892697290L;
    private static final Set<SerializationStrategy> STRATEGIES = Set.of();

    public VirtualLeafNode() {
    }

    public VirtualLeafNode(VirtualRootNode<K, V> root, VirtualLeafRecord<K, V> virtualRecord) {
        super(root, virtualRecord);
    }

    public K getKey() {
        return ((VirtualLeafRecord)this.virtualRecord).getKey();
    }

    public V getValue() {
        return ((VirtualLeafRecord)this.virtualRecord).getValue();
    }

    public Set<SerializationStrategy> supportedSerialization(int version) {
        return STRATEGIES;
    }

    public VirtualLeafNode<K, V> copy() {
        throw new UnsupportedOperationException("Don't use this");
    }

    public long getClassId() {
        return 5302557153892697290L;
    }

    public int getVersion() {
        return 1;
    }

    public String toString() {
        return "VirtualLeafNode{" + this.virtualRecord + "}";
    }

    public void serialize(SerializableDataOutputStream out) throws IOException {
        out.writeSerializable((SelfSerializable)this.virtualRecord, true);
    }

    public void deserialize(SerializableDataInputStream in, int version) throws IOException {
        this.virtualRecord = (VirtualRecord)in.readSerializable();
    }

    private static class ClassVersion {
        public static final int ORIGINAL = 1;

        private ClassVersion() {
        }
    }
}

