/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.virtualmap.internal.merkle;

import com.swirlds.common.io.SerializableDataInputStream;
import com.swirlds.common.io.SerializableDataOutputStream;
import com.swirlds.common.merkle.utility.AbstractMerkleLeaf;
import java.io.IOException;
import java.util.Objects;

public class VirtualMapState
extends AbstractMerkleLeaf {
    public static final long CLASS_ID = -7031935327178054387L;
    private static final int CLASS_VERSION = 1;
    public static final int MAX_LABEL_CHARS = 512;
    public static final int MAX_LABEL_LENGTH = 1536;
    private long firstLeafPath;
    private long lastLeafPath;
    private String label;

    public VirtualMapState() {
        this((String)null);
    }

    public VirtualMapState(String label) {
        this.firstLeafPath = -1L;
        this.lastLeafPath = -1L;
        this.label = label;
    }

    private VirtualMapState(VirtualMapState source) {
        this.firstLeafPath = source.firstLeafPath;
        this.lastLeafPath = source.lastLeafPath;
        this.label = source.label;
    }

    public long getFirstLeafPath() {
        return this.firstLeafPath;
    }

    public void setFirstLeafPath(long path) {
        if (path < 1L && path != -1L) {
            throw new IllegalArgumentException("The path must be positive, or INVALID_PATH, but was " + path);
        }
        if (path > this.lastLeafPath) {
            throw new IllegalArgumentException("The firstLeafPath must be less than or equal to the lastLeafPath");
        }
        this.firstLeafPath = path;
    }

    public long getLastLeafPath() {
        return this.lastLeafPath;
    }

    public void setLastLeafPath(long path) {
        if (path < 1L && path != -1L) {
            throw new IllegalArgumentException("The path must be positive, or INVALID_PATH, but was " + path);
        }
        if (path < this.firstLeafPath) {
            throw new IllegalArgumentException("The lastLeafPath must be greater than or equal to the firstLeafPath");
        }
        this.lastLeafPath = path;
    }

    public long getSize() {
        if (this.firstLeafPath == -1L) {
            return 0L;
        }
        return this.lastLeafPath - this.firstLeafPath + 1L;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        Objects.requireNonNull(label);
        if (label.length() > 512) {
            throw new IllegalArgumentException("Label cannot be greater than 512 characters");
        }
        this.label = label;
    }

    public long getClassId() {
        return -7031935327178054387L;
    }

    public int getVersion() {
        return 1;
    }

    public void serialize(SerializableDataOutputStream out) throws IOException {
        out.writeLong(this.firstLeafPath);
        out.writeLong(this.lastLeafPath);
        out.writeNormalisedString(this.label);
    }

    public void deserialize(SerializableDataInputStream in, int version) throws IOException {
        this.firstLeafPath = in.readLong();
        this.lastLeafPath = in.readLong();
        this.label = in.readNormalisedString(1536);
    }

    public VirtualMapState copy() {
        return new VirtualMapState(this);
    }

    public String toString() {
        return "VirtualMapState{firstLeafPath=" + this.firstLeafPath + ", lastLeafPath=" + this.lastLeafPath + ", size=" + this.getSize() + ", label='" + this.label + "'}";
    }
}

