/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.virtualmap.internal.merkle;

import com.swirlds.common.statistics.StatEntry;
import com.swirlds.common.statistics.StatsBuffered;
import com.swirlds.common.statistics.StatsRunningAverage;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public class VirtualMapStatistics {
    private static final String STAT_CATEGORY = "virtual-map";
    private static final double DEFAULT_HALF_LIFE = 5.0;
    private static final String INT_FORMAT = "%d";
    private static final String FLOAT_FORMAT = "%,10.2f";
    private final List<StatEntry> statistics;
    private final AtomicLong size;
    private final AtomicInteger flushBacklogSize = new AtomicInteger();
    private StatsRunningAverage flushLatency;
    private StatsRunningAverage mergeLatency;

    public VirtualMapStatistics(String label) {
        this.statistics = new LinkedList<StatEntry>();
        this.size = new AtomicLong();
        this.flushLatency = new StatsRunningAverage(5.0);
        this.mergeLatency = new StatsRunningAverage(5.0);
        this.buildStatistics(label);
    }

    private void buildStatistic(String name, String description, String format, Supplier<Object> getStat) {
        this.buildStatistic(name, description, format, null, null, getStat);
    }

    private void buildStatistic(String name, String description, String format, StatsBuffered buffered, Function<Double, StatsBuffered> init, Supplier<Object> getStat) {
        this.statistics.add(new StatEntry(STAT_CATEGORY, name, description, format, buffered, init, null, getStat));
    }

    private void buildStatistics(String label) {
        this.buildStatistic("vMapSize_" + label, "The size of the VirtualMap '" + label + "'", INT_FORMAT, this.size::get);
        this.buildStatistic("vMapFlushLatency_" + label, "The flush latency of VirtualMap '" + label + "'", FLOAT_FORMAT, (StatsBuffered)this.flushLatency, h -> {
            this.flushLatency = new StatsRunningAverage(h.doubleValue());
            return this.flushLatency;
        }, () -> ((StatsRunningAverage)this.flushLatency).getWeightedMean());
        this.buildStatistic("vMapMergeLatency_" + label, "The merge latency of VirtualMap '" + label + "'", FLOAT_FORMAT, (StatsBuffered)this.mergeLatency, h -> {
            this.mergeLatency = new StatsRunningAverage(h.doubleValue());
            return this.mergeLatency;
        }, () -> ((StatsRunningAverage)this.mergeLatency).getWeightedMean());
        this.buildStatistic("vMapFlushBacklog_" + label, "the number of '" + label + "' copies waiting to be flushed", INT_FORMAT, this.flushBacklogSize::get);
    }

    public void registerStatistics(Consumer<StatEntry> registry) {
        for (StatEntry statEntry : this.statistics) {
            registry.accept(statEntry);
        }
    }

    public void setSize(long size) {
        this.size.set(size);
    }

    public void recordFlushLatency(double flushLatency) {
        this.flushLatency.recordValue(flushLatency);
    }

    public void recordMergeLatency(double mergeLatency) {
        this.mergeLatency.recordValue(mergeLatency);
    }

    public void recordFlushBacklogSize(int flushBacklogSize) {
        this.flushBacklogSize.set(flushBacklogSize);
    }
}

