/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.virtualmap.internal.merkle;

import com.swirlds.common.crypto.Hash;
import com.swirlds.common.io.ExternalSelfSerializable;
import com.swirlds.common.io.SerializableDataInputStream;
import com.swirlds.common.io.SerializableDataOutputStream;
import com.swirlds.common.merkle.MerkleNode;
import com.swirlds.common.merkle.exceptions.IllegalChildIndexException;
import com.swirlds.common.merkle.io.SerializationStrategy;
import com.swirlds.common.merkle.route.MerkleRoute;
import com.swirlds.common.merkle.synchronization.utility.MerkleSynchronizationException;
import com.swirlds.common.merkle.synchronization.views.CustomReconnectRoot;
import com.swirlds.common.merkle.synchronization.views.LearnerTreeView;
import com.swirlds.common.merkle.synchronization.views.TeacherTreeView;
import com.swirlds.common.merkle.utility.AbstractMerkleInternal;
import com.swirlds.common.merkle.utility.DebugIterationEndpoint;
import com.swirlds.common.statistics.StatEntry;
import com.swirlds.common.threading.ThreadConfiguration;
import com.swirlds.logging.LogMarker;
import com.swirlds.virtualmap.VirtualKey;
import com.swirlds.virtualmap.VirtualMapSettings;
import com.swirlds.virtualmap.VirtualMapSettingsFactory;
import com.swirlds.virtualmap.VirtualValue;
import com.swirlds.virtualmap.datasource.VirtualDataSource;
import com.swirlds.virtualmap.datasource.VirtualDataSourceBuilder;
import com.swirlds.virtualmap.datasource.VirtualInternalRecord;
import com.swirlds.virtualmap.datasource.VirtualLeafRecord;
import com.swirlds.virtualmap.internal.Path;
import com.swirlds.virtualmap.internal.RecordAccessor;
import com.swirlds.virtualmap.internal.StateAccessor;
import com.swirlds.virtualmap.internal.cache.VirtualNodeCache;
import com.swirlds.virtualmap.internal.hash.VirtualHashListener;
import com.swirlds.virtualmap.internal.hash.VirtualHasher;
import com.swirlds.virtualmap.internal.merkle.RecordAccessorImpl;
import com.swirlds.virtualmap.internal.merkle.VirtualInternalNode;
import com.swirlds.virtualmap.internal.merkle.VirtualLeafNode;
import com.swirlds.virtualmap.internal.merkle.VirtualMapStatistics;
import com.swirlds.virtualmap.internal.merkle.VirtualNode;
import com.swirlds.virtualmap.internal.pipeline.VirtualPipeline;
import com.swirlds.virtualmap.internal.pipeline.VirtualRoot;
import com.swirlds.virtualmap.internal.reconnect.ConcurrentBlockingIterator;
import com.swirlds.virtualmap.internal.reconnect.ReconnectHashListener;
import com.swirlds.virtualmap.internal.reconnect.ReconnectState;
import com.swirlds.virtualmap.internal.reconnect.VirtualLearnerTreeView;
import com.swirlds.virtualmap.internal.reconnect.VirtualTeacherTreeView;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@DebugIterationEndpoint
public final class VirtualRootNode<K extends VirtualKey<? super K>, V extends VirtualValue>
extends AbstractMerkleInternal
implements CustomReconnectRoot<Long, Long>,
ExternalSelfSerializable,
VirtualRoot {
    private static final String NO_NULL_KEYS_ALLOWED_MESSAGE = "Null keys are not allowed";
    public static final long CLASS_ID = 5367589755328273141L;
    private static final Logger LOG = LogManager.getLogger(VirtualRootNode.class);
    private static final Set<SerializationStrategy> STRATEGIES = Set.of(SerializationStrategy.EXTERNAL_SELF_SERIALIZATION);
    private static final int MAX_RECONNECT_HASHING_BUFFER_SIZE = 10000000;
    private static final int MAX_RECONNECT_HASHING_BUFFER_TIMEOUT = 60;
    private final VirtualMapSettings settings = VirtualMapSettingsFactory.get();
    private long maxSizeReachedTriggeringWarning = 0L;
    private VirtualDataSourceBuilder<K, V> dataSourceBuilder;
    private VirtualDataSource<K, V> dataSource;
    private VirtualNodeCache<K, V> cache;
    private StateAccessor state;
    private RecordAccessor<K, V> records;
    private final VirtualHasher<K, V> hasher;
    private VirtualPipeline pipeline;
    private boolean shouldBeFlushed;
    private final CountDownLatch flushLatch = new CountDownLatch(1);
    private final AtomicBoolean hashed = new AtomicBoolean(false);
    private final AtomicBoolean flushed = new AtomicBoolean(false);
    private final AtomicBoolean merged = new AtomicBoolean(false);
    private final AtomicBoolean detached = new AtomicBoolean(false);
    private ConcurrentBlockingIterator<VirtualLeafRecord<K, V>> reconnectIterator = null;
    private CompletableFuture<Hash> reconnectHashingFuture;
    private RecordAccessor<K, V> reconnectRecords;
    private StateAccessor fullyReconnectedState;
    private VirtualLearnerTreeView<K, V> learnerTreeView;
    private final long fastCopyVersion;
    private VirtualMapStatistics statistics;

    public VirtualRootNode() {
        this(null, false);
    }

    public VirtualRootNode(VirtualDataSourceBuilder<K, V> dataSourceBuilder) {
        this(dataSourceBuilder, true);
    }

    private VirtualRootNode(VirtualDataSourceBuilder<K, V> dataSourceBuilder, boolean enforce) {
        super(false);
        this.fastCopyVersion = 0L;
        this.cache = new VirtualNodeCache();
        this.hasher = new VirtualHasher();
        this.shouldBeFlushed = false;
        this.dataSourceBuilder = enforce ? Objects.requireNonNull(dataSourceBuilder) : dataSourceBuilder;
    }

    private VirtualRootNode(VirtualRootNode<K, V> source) {
        super(source);
        this.fastCopyVersion = source.fastCopyVersion + 1L;
        this.dataSourceBuilder = source.dataSourceBuilder;
        this.dataSource = source.dataSource;
        this.cache = source.cache.copy();
        this.hasher = source.hasher;
        this.reconnectHashingFuture = null;
        this.reconnectIterator = null;
        this.reconnectRecords = null;
        this.fullyReconnectedState = null;
        this.learnerTreeView = null;
        this.maxSizeReachedTriggeringWarning = source.maxSizeReachedTriggeringWarning;
        this.pipeline = source.pipeline;
        if (this.pipeline.isTerminated()) {
            throw new IllegalStateException("A fast-copy was made of a VirtualRootNode with a terminated pipeline!");
        }
        this.state = null;
        this.shouldBeFlushed = false;
        this.records = null;
        this.statistics = source.statistics;
    }

    public void postInit(StateAccessor state) {
        if (this.learnerTreeView != null) {
            this.fullyReconnectedState = state;
            return;
        }
        this.state = Objects.requireNonNull(state);
        boolean bl = this.shouldBeFlushed = this.fastCopyVersion != 0L && this.fastCopyVersion % (long)this.settings.getFlushInterval() == 0L;
        if (this.dataSourceBuilder != null && this.dataSource == null) {
            this.dataSource = this.dataSourceBuilder.build(this.createUniqueDataSourceName(state.getLabel()), state.getLabel(), true);
        }
        this.records = new RecordAccessorImpl<K, V>(this.state, this.cache, this.dataSource);
        if (this.statistics == null) {
            this.statistics = new VirtualMapStatistics(state.getLabel());
        }
        if (this.pipeline == null) {
            this.pipeline = new VirtualPipeline();
        }
        this.pipeline.registerCopy(this);
    }

    public StateAccessor getState() {
        return this.state;
    }

    public VirtualDataSource<K, V> getDataSource() {
        return this.dataSource;
    }

    public VirtualNodeCache<K, V> getCache() {
        return this.cache;
    }

    public RecordAccessor<K, V> getRecords() {
        return this.records;
    }

    public VirtualPipeline getPipeline() {
        return this.pipeline;
    }

    @Override
    public boolean isRegisteredToPipeline(VirtualPipeline pipeline) {
        return pipeline == this.pipeline;
    }

    public long getClassId() {
        return 5367589755328273141L;
    }

    public int getVersion() {
        return 1;
    }

    public <T extends MerkleNode> T getChild(int index) {
        VirtualNode node;
        if (this.isReleased() || this.dataSource == null || this.learnerTreeView != null || this.state.getFirstLeafPath() == -1L || index > 1) {
            return null;
        }
        long path = (long)index + 1L;
        if (path < this.state.getFirstLeafPath()) {
            VirtualInternalRecord internalRecord = this.records.findInternalRecord(path);
            if (internalRecord == null) {
                internalRecord = new VirtualInternalRecord(path);
            }
            node = new VirtualInternalNode(this, internalRecord);
        } else if (path <= this.state.getLastLeafPath()) {
            VirtualLeafRecord<K, V> leafRecord = this.records.findLeafRecord(path, false);
            if (leafRecord == null) {
                throw new IllegalStateException("Invalid null record for child index " + index + " (path = " + path + "). First leaf path = " + this.state.getFirstLeafPath() + ", last leaf path = " + this.state.getLastLeafPath() + ".");
            }
            node = new VirtualLeafNode<K, V>(this, leafRecord);
        } else {
            return null;
        }
        MerkleRoute route = this.getRoute().extendRoute(index);
        node.setRoute(route);
        return (T)((Object)node);
    }

    public VirtualRootNode<K, V> copy() {
        this.throwIfImmutable();
        this.throwIfReleased();
        VirtualRootNode<K, V> copy = new VirtualRootNode<K, V>(this);
        this.setImmutable(true);
        if (this.isHashed()) {
            this.cache.seal();
        }
        this.statistics.recordFlushBacklogSize(this.pipeline.getFlushBacklogSize());
        return copy;
    }

    protected void onRelease() {
        if (this.pipeline != null) {
            this.pipeline.releaseCopy();
        }
    }

    public int getNumberOfChildren() {
        return 2;
    }

    protected void setChildInternal(int index, MerkleNode child) {
        throw new UnsupportedOperationException("You cannot set the child of a VirtualRootNode directly with this API");
    }

    protected void allocateSpaceForChild(int index) {
    }

    protected void checkChildIndexIsValid(int index) {
        if (index < 0 || index > 1) {
            throw new IllegalChildIndexException(0, 1, index);
        }
    }

    public long size() {
        return this.state.size();
    }

    public boolean isEmpty() {
        long lastLeafPath = this.state.getLastLeafPath();
        return lastLeafPath == -1L;
    }

    public boolean containsKey(K key) {
        Objects.requireNonNull(key, NO_NULL_KEYS_ALLOWED_MESSAGE);
        VirtualLeafRecord<K, V> rec = this.records.findLeafRecord(key, false);
        return rec != null;
    }

    public V getForModify(K key) {
        this.throwIfImmutable();
        Objects.requireNonNull(key, NO_NULL_KEYS_ALLOWED_MESSAGE);
        VirtualLeafRecord<K, V> rec = this.records.findLeafRecord(key, true);
        if (rec != null) {
            this.markDirty(rec);
        }
        return rec == null ? null : (V)rec.getValue();
    }

    public V get(K key) {
        Objects.requireNonNull(key, NO_NULL_KEYS_ALLOWED_MESSAGE);
        VirtualLeafRecord<K, V> rec = this.records.findLeafRecord(key, false);
        VirtualValue value = rec == null ? null : (VirtualValue)rec.getValue();
        return (V)(value == null ? null : value.asReadOnly());
    }

    public void put(K key, V value) {
        this.throwIfImmutable();
        Objects.requireNonNull(key, NO_NULL_KEYS_ALLOWED_MESSAGE);
        boolean success = this.replaceImpl(key, value);
        if (!success) {
            this.add(key, value);
        }
    }

    public V replace(K key, V value) {
        this.throwIfImmutable();
        Objects.requireNonNull(key, NO_NULL_KEYS_ALLOWED_MESSAGE);
        boolean success = this.replaceImpl(key, value);
        if (success) {
            return value;
        }
        throw new IllegalStateException("Can not replace value that is not in the map");
    }

    public V remove(K key) {
        V value;
        long lastLeafParent;
        this.throwIfImmutable();
        Objects.requireNonNull(key);
        VirtualLeafRecord<K, V> leafToDelete = this.records.findLeafRecord(key, true);
        if (leafToDelete == null) {
            return null;
        }
        this.cache.deleteLeaf(leafToDelete);
        long lastLeafPath = this.state.getLastLeafPath();
        long firstLeafPath = this.state.getFirstLeafPath();
        long leafToDeletePath = leafToDelete.getPath();
        if (leafToDeletePath != lastLeafPath) {
            VirtualLeafRecord<K, V> lastLeaf = this.records.findLeafRecord(lastLeafPath, true);
            assert (lastLeaf != null);
            this.cache.clearLeafPath(lastLeafPath);
            lastLeaf.setPath(leafToDeletePath);
            this.markDirty(lastLeaf);
        }
        if ((lastLeafParent = Path.getParentPath(lastLeafPath)) == 0L) {
            if (firstLeafPath == lastLeafPath) {
                this.state.setFirstLeafPath(-1L);
                this.state.setLastLeafPath(-1L);
            } else {
                this.state.setLastLeafPath(1L);
            }
        } else {
            long lastLeafSibling = Path.getSiblingPath(lastLeafPath);
            VirtualLeafRecord<K, V> sibling = this.records.findLeafRecord(lastLeafSibling, true);
            assert (sibling != null);
            this.cache.clearLeafPath(lastLeafSibling);
            this.cache.deleteInternal(lastLeafParent);
            sibling.setPath(lastLeafParent);
            this.markDirty(sibling);
            this.state.setFirstLeafPath(lastLeafParent);
            this.state.setLastLeafPath(lastLeafSibling - 1L);
        }
        if (this.statistics != null) {
            this.statistics.setSize(this.state.size());
        }
        return (V)((value = leafToDelete.getValue()) == null ? null : value.asReadOnly());
    }

    @Override
    public void onShutdown(boolean immediately) {
        if (immediately) {
            this.hasher.shutdown();
        }
        if (this.dataSource != null) {
            try {
                this.dataSource.close();
            }
            catch (IOException e) {
                LOG.error(LogMarker.EXCEPTION.getMarker(), "Could not close the dataSource after all copies were released", (Throwable)e);
            }
        }
    }

    @Override
    public void merge() {
        long start = System.currentTimeMillis();
        if (!this.isReleased() && !this.isDetached()) {
            throw new IllegalStateException("merge is legal only after this node is released or detached");
        }
        if (!this.isImmutable()) {
            throw new IllegalStateException("merge is only allowed on immutable copies");
        }
        if (!this.isHashed()) {
            throw new IllegalStateException("copy must be hashed before it is merged");
        }
        if (this.merged.get()) {
            throw new IllegalStateException("this copy has already been merged");
        }
        if (this.flushed.get()) {
            throw new IllegalStateException("a flushed copy can not be merged");
        }
        this.cache.merge();
        this.merged.set(true);
        long end = System.currentTimeMillis();
        if (this.statistics != null) {
            this.statistics.recordMergeLatency((double)end - (double)start);
        }
    }

    @Override
    public boolean isMerged() {
        return this.merged.get();
    }

    public void enableFlush() {
        this.shouldBeFlushed = true;
    }

    @Override
    public boolean shouldBeFlushed() {
        return this.shouldBeFlushed;
    }

    @Override
    public boolean isFlushed() {
        return this.flushed.get();
    }

    @Override
    public void waitUntilFlushed() throws InterruptedException {
        if (!this.flushLatch.await(1L, TimeUnit.MINUTES)) {
            this.pipeline.logDebugInfo();
            this.flushLatch.await();
        }
    }

    @Override
    public void flush() {
        if (!this.isImmutable()) {
            throw new IllegalStateException("mutable copies can not be flushed");
        }
        if (this.flushed.get()) {
            throw new IllegalStateException("This map has already been flushed");
        }
        if (this.merged.get()) {
            throw new IllegalStateException("a merged copy can not be flushed");
        }
        long start = System.currentTimeMillis();
        this.flush(this.cache, this.state, this.dataSource);
        this.cache.release();
        long end = System.currentTimeMillis();
        this.flushed.set(true);
        this.flushLatch.countDown();
        if (this.statistics != null) {
            this.statistics.recordFlushLatency((double)end - (double)start);
        }
        LOG.debug(LogMarker.VIRTUAL_MERKLE_STATS.getMarker(), "Flushed in {} ms", (Object)(end - start));
    }

    private void flush(VirtualNodeCache<K, V> cacheToFlush, StateAccessor stateToUse, VirtualDataSource<K, V> ds) {
        try {
            Stream<VirtualLeafRecord<K, V>> sortedDirtyLeaves = cacheToFlush.dirtyLeaves(stateToUse.getFirstLeafPath(), stateToUse.getLastLeafPath());
            Stream<VirtualLeafRecord<K, V>> sortedDeletedLeaves = cacheToFlush.deletedLeaves();
            Stream<VirtualInternalRecord> sortedDirtyInternals = cacheToFlush.dirtyInternals(stateToUse.getFirstLeafPath());
            ds.saveRecords(stateToUse.getFirstLeafPath(), stateToUse.getLastLeafPath(), sortedDirtyInternals, sortedDirtyLeaves, sortedDeletedLeaves);
        }
        catch (IOException ex) {
            LOG.error(LogMarker.EXCEPTION.getMarker(), "Error while flushing VirtualMap", (Throwable)ex);
            throw new UncheckedIOException(ex);
        }
    }

    public Set<SerializationStrategy> supportedSerialization(int version) {
        return STRATEGIES;
    }

    public void serializeExternal(SerializableDataOutputStream out, File outputDirectory) throws IOException {
        RecordAccessor detachedRecords = (RecordAccessor)this.pipeline.detachCopy(this, this.state.getLabel(), outputDirectory.toPath(), false, false);
        assert (detachedRecords.getDataSource() == null) : "No data source should be created.";
        out.writeNormalisedString(this.state.getLabel());
        out.writeSerializable(this.dataSourceBuilder, true);
        out.writeSerializable(detachedRecords.getCache(), true);
    }

    public void deserializeExternal(SerializableDataInputStream in, File inputDirectory, Hash hash, int version) throws IOException {
        String name = in.readNormalisedString(1536);
        this.dataSourceBuilder = (VirtualDataSourceBuilder)in.readSerializable();
        File source = inputDirectory.toPath().resolve(name).toFile();
        if (!source.exists() || !source.isDirectory()) {
            throw new IOException("No virtual map data found at " + source);
        }
        this.dataSource = this.dataSourceBuilder.build(this.createUniqueDataSourceName(name), name, source.toPath(), true);
        this.cache = (VirtualNodeCache)in.readSerializable();
    }

    public boolean isSelfHashing() {
        return true;
    }

    public Hash getHash() {
        if (super.getHash() == null) {
            this.pipeline.hashCopy(this);
        }
        return super.getHash();
    }

    public void setHash(Hash hash) {
        throw new UnsupportedOperationException("data type is self hashing");
    }

    public void invalidateHash() {
        throw new UnsupportedOperationException("this node is self hashing");
    }

    @Override
    public boolean isHashed() {
        return this.hashed.get();
    }

    @Override
    public void computeHash() {
        if (this.hashed.get()) {
            return;
        }
        this.cache.prepareForHashing();
        VirtualHashListener hashListener = new VirtualHashListener<K, V>(){

            @Override
            public void onInternalHashed(VirtualInternalRecord internal) {
                VirtualRootNode.this.cache.putInternal(internal);
            }
        };
        Hash virtualHash = this.hasher.hash(path -> this.records.findLeafRecord(path, false), this.records::findInternalRecord, this.cache.dirtyLeaves(this.state.getFirstLeafPath(), this.state.getLastLeafPath()).iterator(), this.state.getFirstLeafPath(), this.state.getLastLeafPath(), hashListener);
        if (virtualHash == null) {
            VirtualInternalRecord rootRecord = this.state.size() == 0L ? null : this.records.findInternalRecord(0L);
            virtualHash = rootRecord != null ? rootRecord.getHash() : this.hasher.emptyRootHash();
        }
        super.setHash(virtualHash);
        this.cache.seal();
        this.hashed.set(true);
    }

    @Override
    public <T> T detach(String label, java.nio.file.Path destination, boolean reopen, boolean withDbCompactionEnabled) {
        RecordAccessorImpl<K, V> snapshot;
        String snapshotName;
        if (this.isReleased()) {
            throw new IllegalStateException("detach is illegal on already released copies");
        }
        if (!this.isImmutable()) {
            throw new IllegalStateException("detach is only allowed on immutable copies");
        }
        if (!this.isHashed()) {
            throw new IllegalStateException("copy must be hashed before it is detached");
        }
        String string = snapshotName = label == null ? this.createUniqueDataSourceName(this.state.getLabel()) : label;
        if (destination == null) {
            assert (reopen) : "We do not support reopen=false for this path yet";
            snapshot = new RecordAccessorImpl<K, V>(this.state, this.cache.snapshot(), this.dataSourceBuilder.build(snapshotName, this.state.getLabel(), this.dataSource, withDbCompactionEnabled));
        } else if (reopen) {
            VirtualDataSource<K, V> ds = this.dataSourceBuilder.build(snapshotName, destination.resolve(snapshotName), this.dataSource, withDbCompactionEnabled);
            snapshot = new RecordAccessorImpl<K, V>(this.state, this.cache.snapshot(), ds);
        } else {
            try {
                java.nio.file.Path snapshotDir = destination.resolve(snapshotName);
                Files.createDirectories(snapshotDir, new FileAttribute[0]);
                this.dataSource.snapshot(snapshotDir);
                snapshot = new RecordAccessorImpl<K, V>(this.state, this.cache.snapshot(), null);
            }
            catch (IOException e) {
                LOG.error(LogMarker.EXCEPTION.getMarker(), "Failed to take a snapshot of the database", (Throwable)e);
                throw new UncheckedIOException(e);
            }
        }
        this.detached.set(true);
        return (T)snapshot;
    }

    @Override
    public boolean isDetached() {
        return this.detached.get();
    }

    public TeacherTreeView<Long> buildTeacherView() {
        return new VirtualTeacherTreeView(this, this.state, this.pipeline);
    }

    public void setupWithOriginalNode(MerkleNode originalNode) {
        assert (originalNode instanceof VirtualRootNode) : "The original node was not a VirtualRootNode!";
        VirtualRootNode originalMap = (VirtualRootNode)originalNode;
        this.dataSourceBuilder = originalMap.dataSourceBuilder;
        originalMap.dataSource.stopBackgroundCompaction();
        String snapshotName = this.createUniqueDataSourceName(originalMap.state.getLabel());
        this.dataSource = this.dataSourceBuilder.build(snapshotName, originalMap.state.getLabel(), originalMap.dataSource, false);
        assert (originalMap.isHashed()) : "The system should have made sure this was hashed by this point!";
        VirtualNodeCache<K, V> snapshotCache = originalMap.cache.snapshot();
        this.flush(snapshotCache, originalMap.state, this.dataSource);
        this.reconnectIterator = new ConcurrentBlockingIterator(10000000, Integer.MAX_VALUE, TimeUnit.MILLISECONDS);
        this.reconnectHashingFuture = new CompletableFuture();
        ReconnectState reconnectState = new ReconnectState(-1L, -1L);
        this.reconnectRecords = new RecordAccessorImpl<K, V>(reconnectState, snapshotCache, this.dataSource);
        this.learnerTreeView = new VirtualLearnerTreeView<K, V>(this, originalMap.records, originalMap.getState(), reconnectState);
        this.dataSource.copyStatisticsFrom(((VirtualRootNode)originalNode).dataSource);
        this.statistics = originalMap.statistics;
    }

    public void setupWithNoData() {
    }

    public LearnerTreeView<Long> buildLearnerView() {
        return this.learnerTreeView;
    }

    public void registerStatistics(Consumer<StatEntry> registry) {
        this.statistics.registerStatistics(registry);
        this.dataSource.registerStatistics(registry);
    }

    public void handleReconnectLeaf(VirtualLeafRecord<K, V> leafRecord) {
        try {
            boolean success = this.reconnectIterator.supply(leafRecord, 60L, TimeUnit.SECONDS);
            if (!success) {
                throw new MerkleSynchronizationException("Timed out waiting to supply a new leaf to the hashing iterator buffer");
            }
        }
        catch (MerkleSynchronizationException e) {
            throw e;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new MerkleSynchronizationException("Interrupted while waiting to supply a new leaf to the hashing iterator buffer", (Throwable)e);
        }
        catch (Exception e) {
            throw new MerkleSynchronizationException("Failed to handle a leaf during reconnect on the learner", (Throwable)e);
        }
    }

    public void prepareForFirstLeaf() {
        this.reconnectIterator.setMaxWaitTime(60, TimeUnit.SECONDS);
    }

    public void prepareReconnectHashing(long firstLeafPath, long lastLeafPath) {
        ReconnectHashListener<K, V> hashListener = new ReconnectHashListener<K, V>(firstLeafPath, lastLeafPath, this.reconnectRecords.getDataSource());
        new ThreadConfiguration().setComponent("virtualmap").setThreadName("hasher").setRunnable(() -> this.reconnectHashingFuture.complete(this.hasher.hash(path -> this.reconnectRecords.findLeafRecord(path, false), this.reconnectRecords::findInternalRecord, this.reconnectIterator, firstLeafPath, lastLeafPath, hashListener))).setExceptionHandler((thread, exception) -> {
            this.reconnectIterator.close();
            String message = "VirtualMap@" + this.getRoute() + " failed to hash during reconnect";
            LOG.error(LogMarker.EXCEPTION.getMarker(), message, exception);
            this.reconnectHashingFuture.completeExceptionally(new MerkleSynchronizationException(message, exception));
        }).build().start();
    }

    public void endLearnerReconnect() {
        try {
            this.reconnectIterator.close();
            super.setHash(this.reconnectHashingFuture.get());
            this.learnerTreeView = null;
            this.postInit(this.fullyReconnectedState);
            this.dataSource.startBackgroundCompaction();
        }
        catch (ExecutionException e) {
            String message = "VirtualMap@" + this.getRoute() + " failed to get hash during learner reconnect";
            throw new MerkleSynchronizationException(message, (Throwable)e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            String message = "VirtualMap@" + this.getRoute() + " interrupted while ending learner reconnect";
            throw new MerkleSynchronizationException(message, (Throwable)e);
        }
    }

    private void add(K key, V value) {
        long leafPath;
        long lastLeafPath;
        long maximumAllowedSize;
        long currentSize = this.size();
        if (currentSize >= (maximumAllowedSize = this.settings.getMaximumVirtualMapSize())) {
            throw new IllegalStateException("Virtual Map has no more space");
        }
        long remainingCapacity = maximumAllowedSize - currentSize;
        if (currentSize > this.maxSizeReachedTriggeringWarning && remainingCapacity <= this.settings.getVirtualMapWarningThreshold() && remainingCapacity % this.settings.getVirtualMapWarningInterval() == 0L) {
            this.maxSizeReachedTriggeringWarning = currentSize;
            LOG.warn(LogMarker.VIRTUAL_MERKLE_STATS.getMarker(), "Virtual Map only has room for {} additional entries", (Object)remainingCapacity);
        }
        if (remainingCapacity == 1L) {
            LOG.warn(LogMarker.VIRTUAL_MERKLE_STATS.getMarker(), "Virtual Map is now full!");
        }
        if ((lastLeafPath = this.state.getLastLeafPath()) == -1L) {
            leafPath = Path.getLeftChildPath(0L);
            this.state.setLastLeafPath(leafPath);
            this.state.setFirstLeafPath(leafPath);
        } else if (Path.isLeft(lastLeafPath)) {
            leafPath = Path.getRightChildPath(0L);
            this.state.setLastLeafPath(leafPath);
        } else {
            long firstLeafPath = this.state.getFirstLeafPath();
            long nextFirstLeafPath = Path.isFarRight(firstLeafPath) ? Path.getPathForRankAndIndex((byte)(Path.getRank(firstLeafPath) + 1), 0L) : Path.getPathForRankAndIndex(Path.getRank(firstLeafPath), Path.getIndexInRank(firstLeafPath) + 1L);
            VirtualLeafRecord<K, V> oldLeaf = this.records.findLeafRecord(firstLeafPath, true);
            Objects.requireNonNull(oldLeaf);
            this.cache.clearLeafPath(firstLeafPath);
            oldLeaf.setPath(Path.getLeftChildPath(firstLeafPath));
            this.markDirty(oldLeaf);
            leafPath = Path.getRightChildPath(firstLeafPath);
            this.state.setLastLeafPath(leafPath);
            this.state.setFirstLeafPath(nextFirstLeafPath);
        }
        if (this.statistics != null) {
            this.statistics.setSize(this.state.size());
        }
        VirtualLeafRecord<K, V> newLeaf = new VirtualLeafRecord<K, V>(leafPath, null, key, value);
        this.markDirty(newLeaf);
        super.setHash(null);
    }

    private boolean replaceImpl(K key, V value) {
        VirtualLeafRecord<K, V> rec = this.records.findLeafRecord(key, true);
        if (rec != null) {
            rec.setValue(value);
            super.setHash(null);
            return true;
        }
        return false;
    }

    private void markDirty(VirtualLeafRecord<K, V> leaf) {
        this.cache.putLeaf(leaf);
    }

    private String createUniqueDataSourceName(String label) {
        return label + "-" + System.currentTimeMillis();
    }

    public static class ClassVersion {
        public static final int ORIGINAL = 1;
    }
}

